\name{piama_risk_score}
\alias{piama_risk_score}
\title{
PIAMA Risk Score for Asthma Prediction
}
\description{
Calculates the Prevention and Incidence of Asthma and Mite Allergy (PIAMA) Risk Score. This tool predicts the probability of a preschool-aged child (tested around age 4) developing asthma by school age (age 8), based on eight clinical and demographic variables.
}
\usage{
piama_risk_score(sex, gestational_age_gt_40_weeks,
                 parental_education_low_intermediate, parental_asthma,
                 eczema, wheezing_frequency, wheezing_apart_from_colds,
                 inhaled_medication)
}
\arguments{
  \item{sex}{
String. Child's sex ("Male" or "Female"). (Male adds 2 points).
}
  \item{gestational_age_gt_40_weeks}{
Numeric (0 or 1). Was the child born post-term (> 40 weeks gestation)? (1 = Yes, +1 point).
}
  \item{parental_education_low_intermediate}{
Numeric (0 or 1). Is maternal/paternal education level low or intermediate (i.e., not high/tertiary)? (1 = Yes, +1 point).
}
  \item{parental_asthma}{
Numeric (0 or 1). Does a parent have asthma? (1 = Yes, +2 points).
}
  \item{eczema}{
Numeric (0 or 1). Does the child have eczema? (1 = Yes, +1 point).
}
  \item{wheezing_frequency}{
String. Frequency of wheezing in the past year.
"none": 0 points.
"1_to_3": 1-3 episodes (+1 point).
"4_or_more": >= 4 episodes (+5 points).
}
  \item{wheezing_apart_from_colds}{
Numeric (0 or 1). Does wheezing occur apart from colds? (1 = Yes, +2 points).
}
  \item{inhaled_medication}{
Numeric (0 or 1). Did the child use inhaled medication (bronchodilators or steroids) in the last year? (1 = Yes, +4 points).
}
}
\value{
A list containing:
\item{PIAMA_Score}{The calculated risk score (Range 0-18).}
\item{Asthma_Risk_Age_8}{Estimated probability of having asthma at age 8 years.}
}
\references{
Caudri D, Wijga A, A Schipper CM, et al. Predicting the long-term prognosis of children with symptoms suggestive of asthma at preschool age. J Allergy Clin Immunol. 2009;124(5):903-910.e1-7. doi:10.1016/j.jaci.2009.06.045
}
\examples{

# Example 1: High Risk
# Male (+2), Post-term (+1), Parent Asthma (+2), Wheeze >4x (+5), Meds (+4)
# Score = 14
piama_risk_score("male", 1, 0, 1, 0, "4_or_more", 0, 1)

# Example 2: Low Risk
# Female, Term, High Education, No Hx, Wheeze 1-3x (+1)
# Score = 1
piama_risk_score("female", 0, 0, 0, 0, "1_to_3", 0, 0)
}
