\name{rome_iv_belching_disorders}
\alias{rome_iv_belching_disorders}
\title{
Rome IV Diagnostic Criteria for Belching Disorders
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Belching Disorders** (Supragastric Belching or Gastric Belching). Diagnosis is based on the predominant type of belch and requires frequent, recurrent symptoms, chronicity, and the exclusion of aerophagia.
}
\usage{
rome_iv_belching_disorders(symptoms_ge_3_day_week, aerophagia_excluded,
                           supragastric_belch_type, gastric_belch_type,
                           symptom_onset_ge_6_months, symptoms_active_last_3_months)
}
\arguments{
  \item{symptoms_ge_3_day_week}{
Numeric (0 or 1). Recurrent belching occurring on at least **3 days per week**. (1 = Yes).
}
  \item{aerophagia_excluded}{
Numeric (0 or 1). **Aerophagia** (excessive air swallowing) **is excluded**. (1 = Yes).
}
  \item{supragastric_belch_type}{
Numeric (0 or 1). Predominant belch is supragastric (air is drawn into the esophagus and immediately expelled). (1 = Yes).
}
  \item{gastric_belch_type}{
Numeric (0 or 1). Predominant belch is gastric (belch originates from the stomach). (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least **6 months ago**? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have criteria been fulfilled for the last **3 months**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{The resulting classification ("Supragastric Belching", "Gastric Belching", or "Criteria Not Met").}
}
\references{
Yazdanpanah A, Sifrim D. Functional Disorders: Esophageal Disorders. Gastroenterology. 2016;150:1367-1379. doi:10.1053/j.gastro.2016.02.002
}
\examples{

# Example 1: Supragastric Belching
# Freq met, Aerophagia excluded, Supragastric present, Chronic duration met
rome_iv_belching_disorders(1, 1, 1, 0, 1, 1)

# Example 2: Gastric Belching
# Freq met, Aerophagia excluded, Gastric present
rome_iv_belching_disorders(1, 1, 0, 1, 1, 1)
}
