\name{rome_iv_functional_heartburn}
\alias{rome_iv_functional_heartburn}
\title{
Rome IV Diagnostic Criteria for Functional Heartburn
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Functional Heartburn**. This is a functional esophageal disorder defined by retrosternal burning pain in the absence of structural, motor, or reflux disease that explains the symptoms. The defining features are refractory symptoms and the lack of a causal link to acid reflux.
}
\usage{
rome_iv_functional_heartburn(burning_retrosternal_pain, no_symptom_relief_ppi,
                             no_erosive_esophagitis, no_gerd_explanation,
                             no_major_motility_disorder, symptom_onset_ge_6_months,
                             symptoms_active_last_3_months)
}
\arguments{
  \item{burning_retrosternal_pain}{
Numeric (0 or 1). Presence of burning retrosternal pain or discomfort. (1 = Yes).
}
  \item{no_symptom_relief_ppi}{
Numeric (0 or 1). Symptoms are **refractory** to optimal antisecretory therapy (e.g., PPIs). (1 = Yes).
}
  \item{no_erosive_esophagitis}{
Numeric (0 or 1). Absence of erosive esophagitis on Esophagogastroduodenoscopy (EGD). (1 = Yes).
}
  \item{no_gerd_explanation}{
Numeric (0 or 1). Absence of evidence that gastroesophageal reflux (GERD) is the cause of the symptom (e.g., negative symptom association probability/index and normal acid exposure time on reflux monitoring). (1 = Yes).
}
  \item{no_major_motility_disorder}{
Numeric (0 or 1). Absence of major esophageal motor disorders (e.g., achalasia) on high-resolution manometry. (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least **6 months ago**? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last **3 months**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Functional Heartburn" or "Criteria Not Met".}
}
\references{
Aben-Fawaz H, Kahrilas PJ, Chen J. Esophageal disorders. Gastroenterology. 2016;150:1367-1379. doi:10.1053/j.gastro.2016.02.002
}
\examples{

# Example 1: Diagnosis Met
# Burning pain (1), PPI failure (1), No esophagitis (1),
#Normal reflux study (1), No motility issue (1), Chronic
rome_iv_functional_heartburn(1, 1, 1, 1, 1, 1, 1)

# Example 2: Not Met (Pathological Reflux Present)
# Reflux study shows pathological acid exposure time (0 for no_gerd_explanation)
rome_iv_functional_heartburn(1, 1, 1, 0, 1, 1, 1)
}
