\name{set_score}
\alias{set_score}
\title{
SETscore for Stroke Risk Stratification
}
\description{
Calculates the SETscore, a simple clinical tool to help differentiate acute ischemic stroke from stroke mimics in the emergency department. The score is based on three components: Stroke-associated history (S), ECG T-wave inversion (E), and Troponin elevation (T).
}
\usage{
set_score(stroke_associated_history_present, ecg_t_wave_inversion,
          troponin_elevated)
}
\arguments{
  \item{stroke_associated_history_present}{
Numeric (0 or 1). Does the patient have a history strongly associated with stroke? Defined as: History of stroke/TIA OR History of Atrial Fibrillation. (1 = Yes).
}
  \item{ecg_t_wave_inversion}{
Numeric (0 or 1). Are there new T-wave inversions on ECG? (1 = Yes).
}
  \item{troponin_elevated}{
Numeric (0 or 1). Is the serum troponin level elevated (above the 99th percentile upper reference limit)? (1 = Yes).
}
}
\value{
A list containing:
\item{SET_Score}{The calculated score (Range 0-4).}
\item{Recommendation}{Clinical guidance based on the score threshold (Score >= 2 suggests stroke).}
}
\references{
Wong CS, et al. A new score to differentiate stroke from stroke mimics: The SETscore. J Stroke Cerebrovasc Dis. 2021.
}
\examples{

# Example 1: Stroke Likely
# History of AFib (1 -> +2), T-wave inversion (1 -> +1), Normal Trop (0)
# Score = 3
set_score(1, 1, 0)

# Example 2: Unlikely Stroke
# No history, Normal ECG, Normal Trop
# Score = 0
set_score(0, 0, 0)
}
