\name{sledai_2k_score}
\alias{sledai_2k_score}
\title{
Systemic Lupus Erythematosus Disease Activity Index 2000 (SLEDAI-2K)
}
\description{
Calculates the SLEDAI-2K score to assess global disease activity in patients with Systemic Lupus Erythematosus (SLE). It assesses the presence of 24 specific clinical and laboratory variables over the last 10 days (or since the last visit).
}
\usage{
sledai_2k_score(seizure, psychosis, organic_brain_syndrome, visual_disturbance,
                cranial_nerve_disorder, lupus_headache, cva, vasculitis,
                arthritis, myositis, urinary_casts, hematuria, proteinuria,
                pyuria, rash, alopecia, mucosal_ulcers, pleurisy, pericarditis,
                low_complement, increased_dna_binding, fever, thrombocytopenia,
                leukopenia)
}
\arguments{
  \item{seizure}{Numeric (0 or 1). Recent onset of seizure. (1 = Yes, 8 points).}
  \item{psychosis}{Numeric (0 or 1). Altered ability to function in normal activity due to severe disturbance in the perception of reality. (1 = Yes, 8 points).}
  \item{organic_brain_syndrome}{Numeric (0 or 1). Altered mental function with impaired orientation, memory, or other intellectual function. (1 = Yes, 8 points).}
  \item{visual_disturbance}{Numeric (0 or 1). Retinal changes of SLE. (1 = Yes, 8 points).}
  \item{cranial_nerve_disorder}{Numeric (0 or 1). New onset of sensory or motor neuropathy involving cranial nerves. (1 = Yes, 8 points).}
  \item{lupus_headache}{Numeric (0 or 1). Severe, persistent headache. (1 = Yes, 8 points).}
  \item{cva}{Numeric (0 or 1). New onset of cerebrovascular accident (CVA). (1 = Yes, 8 points).}
  \item{vasculitis}{Numeric (0 or 1). Ulceration, gangrene, tender finger nodules, periungual infarction, splinter hemorrhages, or biopsy/angiogram proof. (1 = Yes, 8 points).}
  \item{arthritis}{Numeric (0 or 1). More than 2 joints with pain and signs of inflammation (i.e., tenderness, swelling, or effusion). (1 = Yes, 4 points).}
  \item{myositis}{Numeric (0 or 1). Proximal muscle aching/weakness, associated with elevated CPK/aldolase or EMG changes or biopsy. (1 = Yes, 4 points).}
  \item{urinary_casts}{Numeric (0 or 1). Heme-granular or red blood cell casts. (1 = Yes, 4 points).}
  \item{hematuria}{Numeric (0 or 1). >5 red blood cells/high power field. (1 = Yes, 4 points).}
  \item{proteinuria}{Numeric (0 or 1). >0.5g/24 hours. (1 = Yes, 4 points).}
  \item{pyuria}{Numeric (0 or 1). >5 white blood cells/high power field. (1 = Yes, 4 points).}
  \item{rash}{Numeric (0 or 1). Inflammatory type rash. (1 = Yes, 2 points).}
  \item{alopecia}{Numeric (0 or 1). Abnormal, patchy or diffuse loss of hair. (1 = Yes, 2 points).}
  \item{mucosal_ulcers}{Numeric (0 or 1). Oral or nasal ulceration. (1 = Yes, 2 points).}
  \item{pleurisy}{Numeric (0 or 1). Pleuritic chest pain with pleural rub or effusion or pleural thickening. (1 = Yes, 2 points).}
  \item{pericarditis}{Numeric (0 or 1). Pericardial pain with rub or effusion or EKG confirmation. (1 = Yes, 2 points).}
  \item{low_complement}{Numeric (0 or 1). Decrease in CH50, C3, or C4 below the lower limit of normal. (1 = Yes, 2 points).}
  \item{increased_dna_binding}{Numeric (0 or 1). Increased DNA binding by Farr assay (above normal). (1 = Yes, 2 points).}
  \item{fever}{Numeric (0 or 1). >38 degrees C. (1 = Yes, 1 point).}
  \item{thrombocytopenia}{Numeric (0 or 1). <100,000 platelets/mm^3. (1 = Yes, 1 point).}
  \item{leukopenia}{Numeric (0 or 1). <3,000 white blood cells/mm^3. (1 = Yes, 1 point).}
}
\value{
A list containing:
\item{SLEDAI_2K_Score}{The calculated total score.}
\item{Disease_Activity}{Interpretation of the score (No Activity, Mild, Moderate, High, Very High).}
}
\references{
Gladman DD, Ibañez D, Urowitz MB. Systemic lupus erythematosus disease activity index 2000. J Rheumatol. 2002;29(2):288-291.
}
\examples{

# Example 1: Moderate Activity
# Arthritis (4), Rash (2), Fever (1)
# Score = 7
sledai_2k_score(0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0)

# Example 2: High Activity
# Vasculitis (8), Low Complement (2), Increased DNA Binding (2)
# Score = 12
sledai_2k_score(0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0)
}
