\name{westley_croup_score}
\alias{westley_croup_score}
\title{
Westley Croup Score
}
\description{
Calculates the Westley Croup Score to assess the severity of croup (laryngotracheobronchitis) in children. The score evaluates five clinical signs: chest wall retractions, stridor, cyanosis, level of consciousness, and air entry.
}
\usage{
westley_croup_score(chest_wall_retractions, stridor, cyanosis,
                    level_of_consciousness, air_entry)
}
\arguments{
  \item{chest_wall_retractions}{
Numeric (0-3).
0: None.
1: Mild.
2: Moderate.
3: Severe.
}
  \item{stridor}{
Numeric (0-2).
0: None.
1: With agitation.
2: At rest.
}
  \item{cyanosis}{
Numeric (0-5).
0: None.
4: With agitation.
5: At rest.
}
  \item{level_of_consciousness}{
Numeric (0-5).
0: Normal.
5: Disoriented.
}
  \item{air_entry}{
Numeric (0-2).
0: Normal.
1: Decreased.
2: Markedly decreased.
}
}
\value{
A list containing:
\item{Westley_Score}{The calculated total score (Range 0-17).}
\item{Severity_Classification}{Clinical severity category (Mild <=2, Moderate 3-5, Severe 6-11, Impending Failure >=12).}
}
\references{
Westley CR, Cotton EK, Brooks JG. Nebulized racemic epinephrine by IPPB for the treatment of croup: a double-blind study. Am J Dis Child. 1978;132(5):484-487. doi:10.1001/archpedi.1978.02120300040007
}
\examples{

# Example 1: Moderate Croup
# Mild retractions (1), Stridor at rest (2),
#No cyanosis (0), Normal LOC (0), Decreased air entry (1)
# Score = 4
westley_croup_score(1, 2, 0, 0, 1)

# Example 2: Severe Croup
# Severe retractions (3), Stridor at rest (2),
#Agitated cyanosis (4), Normal LOC (0), Decreased air (1)
# Score = 10
westley_croup_score(3, 2, 4, 0, 1)
}
