% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cnefe.R
\name{read_cnefe}
\alias{read_cnefe}
\title{Read CNEFE data for a given municipality}
\usage{
read_cnefe(
  code_muni,
  year = 2022,
  verbose = TRUE,
  cache = TRUE,
  output = c("arrow", "sf")
)
}
\arguments{
\item{code_muni}{Integer. Seven-digit IBGE municipality code.}

\item{year}{Integer. The CNEFE data year. Currently only 2022 is supported.
Defaults to 2022.}

\item{verbose}{Logical; if \code{TRUE}, print informative messages about
download, extraction, and reading steps.}

\item{cache}{Logical; if \code{TRUE}, cache the downloaded ZIP file in a
user-level cache directory specific to this package. If \code{FALSE}, a
temporary file is used and removed after reading.}

\item{output}{Character. Output format. \code{"arrow"} (default) returns an
\link[arrow:Table-class]{arrow::Table}, whereas \code{"sf"} returns an \link[sf:st_as_sf]{sf} point object
with coordinates built from \code{LONGITUDE} / \code{LATITUDE} in CRS 4674.}
}
\value{
If \code{output = "arrow"}, an \link[arrow:Table-class]{arrow::Table} containing all CNEFE records for
the given municipality.

If \code{output = "sf"}, an \link[sf:st_as_sf]{sf} object with point geometry in
EPSG:4674 (SIRGAS 2000), using the \code{LONGITUDE} and \code{LATITUDE} columns.
}
\description{
Downloads and reads the CNEFE CSV file for a given
IBGE municipality code, using the official IBGE FTP structure. The function
relies on an internal index linking municipality codes to the corresponding
ZIP URLs. Data are returned either as an Arrow \link[arrow:Table-class]{Table}
(default) or as an \link[sf:st_as_sf]{sf} object with SIRGAS 2000 coordinates.
}
\details{
When \code{output = "arrow"} (default), the function does not perform any spatial
conversion and simply returns the Arrow table. When \code{output = "sf"}, the
function converts the result to an \link[sf:st_as_sf]{sf} point object using the
\code{LONGITUDE} and \code{LATITUDE} columns, with CRS EPSG:4674 (SIRGAS 2000),
keeping these columns in the final object (\code{remove = FALSE}).
}
\section{Caching}{

When \code{cache = TRUE} (the default), the downloaded ZIP file is stored in a
user-level cache directory specific to this package, created via
\code{\link[tools:userdir]{tools::R_user_dir()}} with \code{which = "cache"}. This avoids re-downloading
the same municipality file across sessions.

When \code{cache = FALSE}, the ZIP file is stored in a temporary location and
removed when the function exits.
}

\examples{
\donttest{
# Read CNEFE data as an Arrow table
cnefe <- read_cnefe(code_muni = 2929057)

# Read as an sf spatial object
cnefe_sf <- read_cnefe(code_muni = 2929057, output = "sf")
}

}
