% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_statvalues.R
\name{format_chisq}
\alias{format_chisq}
\title{Format Chi-squared statistics}
\usage{
format_chisq(
  x,
  digits = 1,
  pdigits = 3,
  pzero = FALSE,
  italics = TRUE,
  dfs = "par",
  type = "md"
)
}
\arguments{
\item{x}{An \code{htest} object from \code{\link[=cor.test]{cor.test()}}, \code{\link[=t.test]{t.test()}}, or \code{\link[=wilcox.test]{wilcox.test()}}.}

\item{digits}{Number of digits after the decimal for means, confidence
intervals, and test statistics.}

\item{pdigits}{Number of digits after the decimal for p-values, ranging
between 1-5 (also controls cutoff for small p-values).}

\item{pzero}{Logical value (default = FALSE) for whether to include
leading zero for p-values.}

\item{italics}{Logical value (default = TRUE) for whether \emph{p} label should be
italicized.}

\item{dfs}{Formatting for degrees of freedom ("par" = parenthetical,
"sub" = subscript, "none" = do not print degrees of freedom).}

\item{type}{Type of formatting ("md" = markdown, "latex" = LaTeX).}
}
\value{
A character string of statistical information formatted in Markdown or LaTeX.
}
\description{
This is an internal function called by \code{\link[=format_stats]{format_stats()}}, which we
recommend using instead.
}
\examples{
format_stats(chisq.test(matrix(c(12, 5, 7, 7), ncol = 2)))
}
\seealso{
Other functions for printing statistical objects: 
\code{\link{format_bf}()},
\code{\link{format_corr}()},
\code{\link{format_stats}()},
\code{\link{format_stats.BFBayesFactor}()},
\code{\link{format_stats.aov}()},
\code{\link{format_stats.easycorrelation}()},
\code{\link{format_stats.htest}()},
\code{\link{format_stats.lm}()},
\code{\link{format_stats.lmerModLmerTest}()},
\code{\link{format_stats.merMod}()},
\code{\link{format_ttest}()}
}
\concept{functions for printing statistical objects}
