% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_stats_lmerTest.R
\name{format_stats.lmerModLmerTest}
\alias{format_stats.lmerModLmerTest}
\title{Format linear mixed model statistics}
\usage{
\method{format_stats}{lmerModLmerTest}(
  x,
  term = NULL,
  digits = 3,
  pdigits = 3,
  pzero = FALSE,
  full = TRUE,
  italics = TRUE,
  type = "md",
  ...
)
}
\arguments{
\item{x}{An \code{lmerModLmerTest} object from \code{\link[lmerTest:lmer]{lmerTest::lmer()}}.}

\item{term}{Character string for row name of term to extract statistics for.
This must be the exact string returned in the \code{summary()} output from the
\code{lmerModLmerTest} object and can only be fixed effects.}

\item{digits}{Number of digits after the decimal for test statistics.}

\item{pdigits}{Number of digits after the decimal for p-values, ranging
between 1-5 (also controls cutoff for small p-values).}

\item{pzero}{Logical value (default = FALSE) for whether to include
leading zero for p-values.}

\item{full}{Logical value (default = TRUE) for whether to include extra
info (e.g., standard errors and t-values or z-values for terms)
or just test statistic and p-value.}

\item{italics}{Logical value (default = TRUE) for whether statistics labels
should be italicized.}

\item{type}{Type of formatting ("md" = markdown, "latex" = LaTeX).}

\item{...}{Additional arguments passed to methods.}
}
\value{
A character string of statistical information formatted in Markdown or LaTeX.
}
\description{
This method formats linear mixed model statistics from the
class \code{lmerModLmerTest} from the
\{\href{https://cran.r-project.org/package=lmerTest}{lmerTest}\} package.
Only fixed effects can be extracted.
The default output is APA formatted, but this function allows
control over numbers of digits, leading zeros, italics,
and output format of Markdown or LaTeX.
}
\examples{
test_lmer <- lmerTest::lmer(mpg ~ hp + (1 | cyl), data = mtcars)

# Format linear mixed model term statistics
format_stats(test_lmer, term = "hp")

# Remove italics
format_stats(test_lmer, term = "hp", italics = FALSE)

# Change digits and add leading zero to p-value
format_stats(test_lmer, term = "hp", digits = 3, pdigits = 4, pzero = TRUE)

# Format for LaTeX
format_stats(test_lmer, term = "hp", type = "latex")
}
\seealso{
Other functions for printing statistical objects: 
\code{\link{format_bf}()},
\code{\link{format_chisq}()},
\code{\link{format_corr}()},
\code{\link{format_stats}()},
\code{\link{format_stats.BFBayesFactor}()},
\code{\link{format_stats.aov}()},
\code{\link{format_stats.easycorrelation}()},
\code{\link{format_stats.htest}()},
\code{\link{format_stats.lm}()},
\code{\link{format_stats.merMod}()},
\code{\link{format_ttest}()}
}
\concept{functions for printing statistical objects}
