% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver_newton.R
\name{fisher_scoring}
\alias{fisher_scoring}
\title{Fisher Scoring Solver}
\usage{
fisher_scoring(
  line_search = TRUE,
  max_iter = 50L,
  tol = 1e-08,
  backtrack_ratio = 0.5,
  min_step = 1e-12,
  verbose = FALSE
)
}
\arguments{
\item{line_search}{Use backtracking line search for stability}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Convergence tolerance (on parameter change)}

\item{backtrack_ratio}{Step size reduction factor for line search}

\item{min_step}{Minimum step size before giving up}

\item{verbose}{Logical; if TRUE and the \pkg{cli} package is installed,
display progress during optimization. Default is FALSE.}
}
\value{
A solver function with signature (problem, theta0, trace) ->
  mle_result
}
\description{
Variant of Newton-Raphson that uses the expected Fisher information
instead of the observed Fisher. Can be more stable for some problems.
}
\details{
Fisher scoring is identical to Newton-Raphson when the expected and
observed Fisher information are equal (e.g., exponential families).
For other models, it may have different convergence properties.
}
\examples{
\donttest{
set.seed(42)
x <- rnorm(50, 5, 2)
problem <- mle_problem(
  loglike = function(theta) sum(dnorm(x, theta[1], theta[2], log = TRUE)),
  constraint = mle_constraint(
    support = function(theta) theta[2] > 0,
    project = function(theta) c(theta[1], max(theta[2], 1e-8))
  )
)
solver <- fisher_scoring()
result <- solver(problem, c(4, 1.5))
}

}
