% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcf.R
\name{leases_tbl_structuration}
\alias{leases_tbl_structuration}
\title{Aggregate lease events into annual vectors aligned on base_year..base_year+horizon-1}
\usage{
leases_tbl_structuration(ev, horizon, base_year)
}
\arguments{
\item{ev}{list of events with fields: start, end, rent, vac, free_months,
capex_sqm, new_lease.}

\item{horizon}{integer(1) >= 1, number of annual steps.}

\item{base_year}{integer(1), first absolute year of the horizon.}
}
\value{
list with numeric vectors of length \code{horizon}:
\code{rent}, \code{vac}, \code{free}, \code{capex_sqm}, \code{new_lease}.
}
\description{
Converts a list of lease events into annual vectors for rent, vacancy, free months,
tenant capex (€/sqm), and a new_lease flag. The \verb{[start, end]} convention is used:
an event applies to years y with start <= y <= end. Overlaps within a unit resolve as:
rent/vac/new_lease: last event wins; capex_sqm/free_months: accumulated at start year.
Returned vectors are \strong{non-indexed} (indexation is applied later in cfg_normalize()).
}
