% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{styles_distressed_exit}
\alias{styles_distressed_exit}
\title{Distressed exit diagnostic across CRE investment styles}
\usage{
styles_distressed_exit(
  styles,
  regimes,
  fire_sale_bps = 100,
  refi_min_year = 3L,
  allow_year1_distress = TRUE,
  ext_dir = system.file("extdata", package = "cre.dcf")
)
}
\arguments{
\item{styles}{Character vector of style tags, e.g.
\code{c("core", "core_plus", "value_added", "opportunistic")}.}

\item{regimes}{A data frame or tibble with at least three columns:
\code{regime} (label), \code{min_dscr} (numeric), \code{max_ltv} (numeric).
Each row defines a covenant regime (strict / baseline / flexible, etc.).}

\item{fire_sale_bps}{Numeric scalar. Widening (in basis points) applied to
the exit-yield spread in the distressed run (e.g. \code{+100} for +100 bps).}

\item{refi_min_year}{Integer scalar. Minimum year at which a lender-driven
distressed exit can occur. If a breach is detected before this year and
\code{allow_year1_distress = FALSE}, the distressed exit is moved to
\code{refi_min_year}.}

\item{allow_year1_distress}{Logical. If \code{TRUE}, distress can occur in year 1.
If \code{FALSE}, breaches in years \verb{< refi_min_year} are shifted to
\code{refi_min_year} (refinancing window logic).}

\item{ext_dir}{Optional directory where style presets (YAML) are stored.
Defaults to the package \code{inst/extdata} folder.}
}
\value{
A tibble with one row per combination of style and regime, and the
columns:
\itemize{
\item \code{style}, \code{regime}, \code{min_dscr}, \code{max_ltv},
\item \code{breach_year}, \code{breach_type},
\item \code{irr_equity_base}, \code{irr_equity_distress},
\item \code{distress_undefined} (logical),
\item \code{equity_multiple_base}, \code{equity_multiple_distress},
\item \code{equity_loss_pct_base}, \code{equity_loss_pct_distress},
\item \code{sale_value_distress}.
}
}
\description{
This helper applies a simple lender-driven distressed-exit rule to a set of
canonical style presets. For each style and covenant regime, it:
\enumerate{
\item Runs the baseline case via \code{\link[=run_case]{run_case()}}.
\item Identifies the first covenant breach under the bullet-debt scenario
(DSCR and forward LTV).
\item Optionally shifts very early breaches to a minimum refinancing year
(refinancing window logic).
\item Re-runs the case with a shortened horizon and a fire-sale exit-yield
penalty, and extracts:
\itemize{
\item distressed equity IRR (possibly NA),
\item distressed equity multiple and loss percentage,
\item distressed sale value.
}
}
}
