% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingLowestDoseHSRBeta-class}
\alias{StoppingLowestDoseHSRBeta-class}
\alias{.StoppingLowestDoseHSRBeta}
\alias{StoppingLowestDoseHSRBeta}
\alias{.DefaultStoppingLowestDoseHSRBeta}
\title{\code{StoppingLowestDoseHSRBeta}}
\usage{
StoppingLowestDoseHSRBeta(
  target = 0.3,
  prob = 0.95,
  a = 1,
  b = 1,
  report_label = NA_character_
)

.DefaultStoppingLowestDoseHSRBeta()
}
\arguments{
\item{target}{(\code{proportion})\cr see slot definition.}

\item{prob}{(\code{proportion})\cr see slot definition.}

\item{a}{(\code{number})\cr see slot definition.}

\item{b}{(\code{number})\cr see slot definition.}

\item{report_label}{(\code{string} or \code{NA})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{StoppingLowestDoseHSRBeta}} is a class for stopping based on a Hard Safety
Rule using the Beta posterior distribution with Beta(a,b) prior and a
Bin-Beta model based on the observed data at the lowest dose level.
The rule is triggered when the first dose is considered to be toxic
(i.e. above threshold probability) based on the observed data at the
lowest dose level and a Beta(a,b) prior distribution.
The default prior is Beta(1,1).
In case that placebo is used, the rule is evaluated at the second dose of the
dose grid, i.e. at the lowest non-placebo dose.
}
\section{Slots}{

\describe{
\item{\code{target}}{(\code{proportion})\cr the target toxicity.}

\item{\code{prob}}{(\code{proportion})\cr the threshold probability for the lowest dose
being toxic.}

\item{\code{a}}{(\code{number})\cr shape parameter \eqn{a > 0} of probability distribution
Beta (a,b).}

\item{\code{b}}{(\code{number})\cr shape parameter \eqn{b > 0} of probability distribution
Beta (a,b).}
}}

\note{
This stopping rule is independent from the underlying model.

Typically, end users will not use the \code{.DefaultStoppingLowestDoseHSRBeta()} function.
}
\examples{
# Stopping the study if the first dose is toxic with more than 90\%
# probability based on a Beta posterior distribution with Beta(1,1) prior.
my_stopping <- StoppingLowestDoseHSRBeta(
  target = 0.3,
  prob = 0.9
)

# Stopping the study if the first dose is toxic with more than 90\%
# probability based on a Beta posterior distribution with Beta(0.5,0.5) prior.
my_stopping <- StoppingLowestDoseHSRBeta(
  target = 0.3,
  prob = 0.9,
  a = 0.5,
  b = 0.5
)
}
