% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_glm.R
\name{cla_glm}
\alias{cla_glm}
\title{Logistic regression (GLM)}
\usage{
cla_glm(attribute, positive, features = NULL, threshold = 0.5)
}
\arguments{
\item{attribute}{target attribute name}

\item{positive}{positive class label}

\item{features}{optional vector of feature names (default: all except attribute)}

\item{threshold}{probability threshold for positive class}
}
\value{
returns a \code{cla_glm} object
}
\description{
Logistic regression classifier using \code{stats::glm} with binomial family.
}
\examples{
data(iris)
iris_bin <- iris
iris_bin$IsVersicolor <- factor(ifelse(
 iris_bin$Species == "versicolor",
 "versicolor",
 "not_versicolor"
))
model <- cla_glm("IsVersicolor", positive = "versicolor")
model <- suppressWarnings(fit(model, iris_bin))
pred <- predict(model, iris_bin)
table(pred, iris_bin$IsVersicolor)
}
