% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_plot_bar.R
\name{plot_bar}
\alias{plot_bar}
\title{Plot bar graph}
\usage{
plot_bar(data, label_x = "", label_y = "", colors = NULL, alpha = 1)
}
\arguments{
\item{data}{two‑column data.frame: category in the first column, numeric values in the second}

\item{label_x}{x‑axis label}

\item{label_y}{y‑axis label}

\item{colors}{optional fill color (single value)}

\item{alpha}{bar transparency (0–1)}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Draw a simple bar chart from a two‑column data.frame: first column as categories (x), second as values.
}
\details{
If \code{colors} is provided, a constant fill is used; otherwise ggplot2's default palette applies.
\code{alpha} controls bar transparency. The first column is coerced to factor when needed.
}
\examples{
#summarizing iris dataset
data <- iris |> dplyr::group_by(Species) |>
dplyr::summarize(Sepal.Length=mean(Sepal.Length))
head(data)

# plotting data
grf <- plot_bar(data, colors="blue")
plot(grf)
}
