% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_plot_boxplot_class.R
\name{plot_boxplot_class}
\alias{plot_boxplot_class}
\title{Boxplot per class}
\usage{
plot_boxplot_class(
  data,
  class_label,
  label_x = "",
  label_y = "",
  colors = NULL
)
}
\arguments{
\item{data}{data.frame with a grouping column and one numeric column}

\item{class_label}{name of the grouping (class) column}

\item{label_x}{x‑axis label}

\item{label_y}{y‑axis label}

\item{colors}{optional fill color for the boxes}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Boxplots of a numeric column grouped by a class label.
}
\details{
Expects a data.frame with the grouping column named in \code{class_label} and one numeric column.
The function melts to long format and draws per‑group distributions.
}
\examples{
grf <- plot_boxplot_class(iris |> dplyr::select(Sepal.Width, Species),
class_label = "Species", colors=c("red", "green", "blue"))
plot(grf)
}
