% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_plot_lollipop.R
\name{plot_lollipop}
\alias{plot_lollipop}
\title{Plot lollipop}
\usage{
plot_lollipop(
  data,
  label_x = "",
  label_y = "",
  colors = NULL,
  color_text = "black",
  size_text = 3,
  size_ball = 8,
  alpha_ball = 0.2,
  min_value = 0,
  max_value_gap = 1
)
}
\arguments{
\item{data}{data.frame with category and numeric values}

\item{label_x}{x‑axis label}

\item{label_y}{y‑axis label}

\item{colors}{stick/circle color}

\item{color_text}{color of the text inside the circle}

\item{size_text}{text size}

\item{size_ball}{circle size}

\item{alpha_ball}{circle transparency (0–1)}

\item{min_value}{minimum baseline for the stick}

\item{max_value_gap}{gap from value to stick end}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Lollipop chart (stick + circle + value label) per category.
}
\details{
Expects a data.frame with category in the first column and numeric values in subsequent columns.
Circles are drawn at values, with vertical segments extending from \code{min_value} to \code{value - max_value_gap}.
}
\examples{
#summarizing iris dataset
data <- iris |> dplyr::group_by(Species) |>
dplyr::summarize(Sepal.Length=mean(Sepal.Length))
head(data)

#ploting data
grf <- plot_lollipop(data, colors="blue", max_value_gap=0.2)
plot(grf)
}
