% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lackinfo.int}
\alias{lackinfo.int}
\title{Lack of Information Questionnaire Interval Dataset}
\format{
A data frame with 50 observations and 8 variables:
\itemize{
    \item \code{id}: Identification number.
    \item \code{sex}: Sex of the respondent (\code{male} or \code{female}).
    \item \code{age}: Respondent's age (in years).
    \item \code{item1}: Interval-valued answer to item 1.
    \item \code{item2}: Interval-valued answer to item 2.
    \item \code{item3}: Interval-valued answer to item 3.
    \item \code{item4}: Interval-valued answer to item 4.
    \item \code{item5}: Interval-valued answer to item 5.
}
}
\source{
\url{https://CRAN.R-project.org/package=IntervalQuestionStat}
}
\usage{
data(lackinfo.int)
}
\description{
Interval-valued dataset from a lack-of-information questionnaire.
Contains biographical data and responses to 5 items measuring perception
of lack of information, collected via an interval-valued Likert scale.
}
\details{
An educational innovation project was carried out for improving
teaching-learning processes at the University of Oviedo (Spain)
for the 2020/2021 academic year. A total of 50 students answered
an online questionnaire about biographical data (sex and age) and
their perception of lack of information by selecting the interval
that best represents their level of agreement on a scale bounded
between 1 (strongly disagree) and 7 (strongly agree).

The 5 items measuring perception of lack of information are:
\itemize{
    \item I1: I receive too little information from my classmates.
    \item I2: It is difficult to receive relevant information from my classmates.
    \item I3: It is difficult to receive relevant information from the teacher.
    \item I4: The amount of information I receive from my classmates is very low.
    \item I5: The amount of information I receive from the teacher is very low.
}
}
\examples{
data(lackinfo.int)
}
\keyword{datasets}
\keyword{interval}
