% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_frequency}
\alias{check_frequency}
\alias{assert_frequency}
\title{Vérifie la conformité d'une fréquence}
\usage{
check_frequency(x, .var.name = checkmate::vname(x), warn = TRUE)

assert_frequency(x, add = NULL, .var.name = checkmate::vname(x), warn = TRUE)
}
\arguments{
\item{x}{un entier qui vaut \code{4L} (ou \code{4.0}) pour les séries trimestrielles et
\code{12L} (ou \code{12.0}) pour les séries mensuelles.}

\item{.var.name}{Nom de l'objet à vérifier pour afficher dans les messages}

\item{warn}{un booleen}

\item{add}{Collection pour stocker les messages d'erreurs (Default is NULL)}
}
\value{
En sortie la fonction retourne l'objet \code{x} de manière invisible ou
une erreur.
}
\description{
Vérifie la conformité d'une fréquence
}
\details{
La fréquence d'une série temporelle est soit mensuelle (\code{12L} ou
\code{12.0}) soit trimestrielle (\code{4L} ou \code{4.0}). Les autres fréquences ne sont pas
acceptées.
Cette fonction s'appuie essentiellement sur les fonctions
\code{checkmate::check_numeric}, \code{checkmate::check_int} et
\code{checkmate::check_choice}.
Il y a néanmoins une petite subtilité : on vérifie si l'objet \code{x} est de type
double ou integer.
Dans le premier cas, on affichera un warning et on corrigera l'objet au
format integer pour les traitements ultérieurs. En sortie, \code{x} est retourné
de manière invisible.
Si l'argument \code{warn} est \code{FALSE}, alors la fonction ne retournera pas de
warning lors de l'évaluation.

Selon le préfixe de la fonction :
\itemize{
\item si le check réussi :
\itemize{
\item la fonction \code{assert_frequency} retourne l'objet \code{x} de manière
invisible;
\item la fonction \code{check_frequency} retourne le booléen \code{TRUE}.
}
\item si le check échoue :
\itemize{
\item la fonction \code{assert_frequency} retourne un message d'erreur;
\item la fonction \code{check_frequency} retourne une chaîne de caractère
signalant le problème.
}
}
}
\examples{

assert_frequency(4L)
assert_frequency(12L)

check_frequency(4L)
check_frequency(12L)

# Avec des erreurs,

check_frequency(Inf, warn = FALSE)
check_frequency(1:10)
check_frequency(1L)

}
