% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/counters.R
\name{get_counters}
\alias{get_counters}
\alias{[.DEFM_counters}
\alias{set_counter_info}
\alias{length.DEFM_counters}
\alias{as.list.DEFM_counters}
\alias{as.list.DEFM_counter}
\alias{set_counters_names}
\alias{set_counters_names.DEFM}
\alias{set_counters_names.DEFM_counters}
\title{Extract the counters from a DEFM model}
\usage{
get_counters(model)

\method{[}{DEFM_counters}(counters, i)

set_counter_info(counter, new_name = "", new_desc = "")

\method{length}{DEFM_counters}(x)

\method{as.list}{DEFM_counters}(x, ...)

\method{as.list}{DEFM_counter}(x, ...)

set_counters_names(x, ...)

\method{set_counters_names}{DEFM}(x, ...)

\method{set_counters_names}{DEFM_counters}(x, ...)
}
\arguments{
\item{model}{A \link{DEFM} model object.}

\item{counters}{An object of class \code{DEFM_counters}.}

\item{i}{Integer from 0 to nterms - 1. Counter to get.}

\item{counter}{An object of class \code{DEFM_counter}.}

\item{new_name, new_desc}{Strings with the new name and new description,
respectively. If empty, no side effect.}

\item{x}{Either a \code{DEFM_counters} or a \code{DEFM_counter} object.}

\item{...}{Further arguments passed to the method (not used).}
}
\value{
\itemize{
\item The function \code{get_counters} returns an external pointer to an object of
class \code{DEFM_counters}.
}

\itemize{
\item The method \verb{[.DEFM_counters} returns an individual counter of class
\code{DEFM_counter}.
}

\itemize{
\item \code{set_counter_info()} invisibly returns the modified counter.
}

\itemize{
\item The \code{length} method for \code{DEFM_counters} returns the number of counters
in the vector. This should match the return from \code{\link[=nterms_defm]{nterms_defm()}}.
}

\itemize{
\item The \code{as.list} methods return a list with the name and description
of the counters.
}

\itemize{
\item The function \code{set_counters_names()} returns the counters invisibly.
}
}
\description{
Counters are functions that are defined in terms of the change statistics.
The counters also contain a hasher that is used internally to check whether
an array's support is cached or not (see details).
}
\details{
If the hash of an array--which are built using each counters' individual
hashing functions--matches an existing array, then, the DEFM models reduce
computational burden by recycling computations of the normalizing constant.
For example, if a model only includes terms (counters) that do not feature
individual-level characteristics like gender or age, then most likely all
arrays in that model will use the same normalizing constant.

The function \code{set_counter_info()} can be used to modify a counter name
and description. This is especially useful when a name is particularly
long.
}
