% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{speed_date}
\alias{speed_date}
\title{Speed dating data}
\format{
A tibble with 180 rows and 5 variables
}
\source{
\href{https://www.discovr.rocks/csv/speed_date.csv}{www.discovr.rocks/csv/speed_date.csv}
}
\usage{
speed_date
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
Imagine a scientist designed a study to look at the interplay between looks, personality and
dating strategies on evaluations of a date. She set up a speed-dating night with 9 tables at which there
sat a 'date'. All the dates were stooges selected to vary in their attractiveness (high, average and low),
their personality (high charisma, average charisma, writes statistics books), and also the strategy
they were told to employ during the conversation (normal or playing hard to get).
The dates were trained before the study to act charismatically to varying degrees, and also how to act
in a way that made them seem unobtainable (hard to get) or not. As such, across the nine dates/stooges
there were three 'high attractive' people one of whom acted charismatically, one who acted normally (average) and
another who acted with low charisma, likewise for the three average looking dates and the three low attractiveness dates.
Therefore, each participant attending a speed-dating night would be exposed to all combinations of attractiveness and charisma
(these are repeated measures).

Upon arrival participants were randomly assigned a blue or red sticker.
For the participants with the red sticker the stooges played hard to get (unobtainable) and for
those with a blue sticker they acted normally. Over the course a few nights 20 people attended,
spent 5-minutes with each of the 9 'dates' and then rated how much they'd like to have a proper date with the person
as a percentage (100\% = 'I'd pay large sums of money for their phone number', 0\% = 'I'd pay a large sum of money for a plane
ticket to get me as far away from them as possible'). The (fictional) data contains the following variables:
\itemize{
\item \strong{id}: participant ID
\item \strong{strategy}: Whether the stooge acted normally or played hard to get
\item \strong{looks}: Whether the stooge was rated as high, average or low on looks
\item \strong{charisma}: Whether the stooge acted with high, average or low charisma
\item \strong{date}: rating how much the participant would like to have a proper date with the stooge as a percentage (100\% = 'I'd pay large sums of money for their phone number', 0\% = 'I'd pay a large sum of money for a plane ticket to get me as far away from them as possible')
}
}
\keyword{datasets}
