% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdplot.R
\name{cdplot}
\alias{cdplot}
\title{Visualizing the experimental outcome with cumulative distribution functions.}
\arguments{
\item{data}{A data.frame including two columns, one recording the outcome and the other recording the assignment. The assignment column must be named as \code{group}.}

\item{ks_test}{A logical option to indicate whether to show the Kolmogorov-Smirnov test result in the bottom-right corner. The default value is FALSE.}

\item{point_size}{An integer to indicate the size of the points at the largest difference. The default value is 3.}

\item{point_color}{An character or function to indicate the color of the points at the largest difference. The default value is \code{drhutools::gb_cols("red")}.}

\item{link_color}{An character or function to indicate the color of the link at the largest difference. The default value is \code{drhutools::gb_cols("red")}.}
}
\value{
A list of \code{ggplot2} objects comparing the ECDFs between the control and treatment groups and identifying at most three largest differences.
}
\description{
Packed \code{ggplot2} function to compare the empirical cumulative distribution functions (ECDF) between the treatment and control groups in an experiment or quasi-experiment.
}
\examples{

data("PlantGrowth")

plot_plant <- cdplot(PlantGrowth, ks_test = TRUE)
plot_plant

}
