% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{create_gene_level_scna_df}
\alias{create_gene_level_scna_df}
\title{Create Gene-level SCNA Data Frame}
\usage{
create_gene_level_scna_df(
  scna_segs_df,
  build = "GRCh37",
  gene_overlap_threshold = 25
)
}
\arguments{
\item{scna_segs_df}{the SCNA segments data frame. Must contain: \describe{
\item{chr}{chromosome the segment is located in}
\item{start}{start position of the segment}
\item{end}{end position of the segment}
\item{log2ratio}{\ifelse{html}{\out{log<sub>2</sub>}}{\eqn{log_2}} ratio of the segment}
}}

\item{build}{genome build for the SCNA segments data frame (default = 'GRCh37')}

\item{gene_overlap_threshold}{the percentage threshold for the overlap between
a segment and a transcript (default = 25). This means that if only a segment
overlaps a transcript more than this threshold, the transcript is assigned
the segment's SCNA event.}
}
\value{
data frame of gene-level SCNA events, i.e. table of genes overlapped
by SCNA segments.
}
\description{
Create Gene-level SCNA Data Frame
}
