% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.igb_standards.R
\name{ds.igb_standards}
\alias{ds.igb_standards}
\title{Converts birth measurements to intergrowth z-scores/centiles}
\usage{
ds.igb_standards(
  gagebrth = NULL,
  z = 0,
  p = 50,
  val = NULL,
  var = NULL,
  sex = NULL,
  fun = "igb_value2zscore",
  newobj = NULL,
  datasources = NULL
)
}
\arguments{
\item{gagebrth}{the name of the "gestational age at birth in days" variable.}

\item{z}{z-score(s) to convert (must be between 0 and 1). Default value is 0.
This value is used only if \code{fun} is set to "igb_zscore2value".}

\item{p}{centile(s) to convert (must be between 0 and 100). Default value is p=50. 
This value is used only if \code{fun} is set to "igb_centile2value".}

\item{val}{the name of the anthropometric variable to convert.}

\item{var}{the name of the measurement to convert ("lencm", "wtkg", "hcircm", "wlr").}

\item{sex}{the name of the sex factor variable. The variable should be coded as Male/Female.
If it is coded differently (e.g. 0/1), then you can use the ds.recodeValues function to 
recode the categories to Male/Female before the use of ds.igb_standards.}

\item{fun}{the name of the function to be used. This can be one of: "igb_centile2value",
"igb_zscore2value", "igb_value2zscore" (default), "igb_value2centile".}

\item{newobj}{a character string that provides the name for the output variable
that is stored on the data servers. Default name is set to \code{igb.newobj}.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} objects obtained after login. 
If the \code{datasources} argument is not specified the default set of connections will be
used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
assigns the converted measurement as a new object on the server-side
}
\description{
Converts birth measurements to INTERGROWTH z-scores/centiles (generic)
}
\note{
For gestational ages between 24 and 33 weeks, the INTERGROWTH very early preterm 
standard is used.
}
\references{
\itemize{
 \item Villar, J., Ismail, L.C., Victora, C.G., Ohuma, E.O., Bertino, E., 
 Altman, D.G., Lambert, A., Papageorghiou, A.T., Carvalho, M., Jaffer, Y.A., 
 Gravett, M.G., Purwar, M., Frederick, I.O., Noble, A.J., Pang, R., Barros, 
 F.C., Chumlea, C., Bhutta, Z.A., Kennedy, S.H., 2014. International 
 standards for newborn weight, length, and head circumference by gestational 
 age and sex: the Newborn Cross-Sectional Study of the INTERGROWTH-21st 
 Project. The Lancet 384, 857--868. https://doi.org/10.1016/S0140-6736(14)60932-6
 \item Villar, J., Giuliani, F., Fenton, T.R., Ohuma, E.O., Ismail, L.C., 
 Kennedy, S.H., 2016. INTERGROWTH-21st very preterm size at birth reference 
 charts. The Lancet 387, 844--845. https://doi.org/10.1016/S0140-6736(16)00384-6
 
}
}
\author{
Demetris Avraam for DataSHIELD Development Team
}
