% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_register.R
\name{ddbs_register_vector}
\alias{ddbs_register_vector}
\title{Register an SF Object as an Arrow Table in DuckDB}
\usage{
ddbs_register_vector(conn, data, name, overwrite = FALSE, quiet = FALSE)
}
\arguments{
\item{conn}{A connection object to a DuckDB database}

\item{data}{A \code{sf} object to write to the DuckDB database, or the path to
a local file that can be read with \code{ST_READ}}

\item{name}{A character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table
names. If \code{NULL} (the default), the function returns the result as an
\code{sf} object}

\item{overwrite}{Boolean. whether to overwrite the existing table if it exists. Defaults
to \code{FALSE}. This argument is ignored when \code{name} is \code{NULL}.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
TRUE (invisibly) on successful registration.
}
\description{
This function registers a Simple Features (SF) object as a temporary Arrow-backed
view in a DuckDB database. This is a zero-copy operation and is significantly
faster than \code{ddbs_write_vector} for workflows that do not require data to be
permanently materialized in the database.
}
\examples{
\dontrun{
library(duckspatial)
library(sf)

conn <- ddbs_create_conn("memory")

nc <- st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)

ddbs_register_vector(conn, nc, "nc_arrow_view")

dbGetQuery(conn, "SELECT COUNT(*) FROM nc_arrow_view;")

ddbs_stop_conn(conn, shutdown = TRUE)
}
}
