% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{edge_find_gguf_models}
\alias{edge_find_gguf_models}
\title{Find and prepare GGUF models for use with edgemodelr}
\usage{
edge_find_gguf_models(
  source_dirs = NULL,
  target_dir = NULL,
  create_links = TRUE,
  model_pattern = NULL,
  test_compatibility = TRUE,
  min_size_mb = 50,
  verbose = TRUE
)
}
\arguments{
\item{source_dirs}{Vector of directories to search for GGUF files. If NULL,
automatically searches common locations including Ollama installation.}

\item{target_dir}{Directory where to create links/copies of compatible models.
If NULL, creates a "local_models" directory in the current working directory.}

\item{create_links}{Logical. If TRUE (default), creates symbolic links to save disk space.
If FALSE, copies the files (uses more disk space but more compatible).}

\item{model_pattern}{Optional pattern to filter model files by name.}

\item{test_compatibility}{Logical. If TRUE (default), tests each GGUF file for
compatibility with edgemodelr before including it.}

\item{min_size_mb}{Minimum file size in MB to consider (default: 50MB).
Helps filter out config files and focus on actual models.}

\item{verbose}{Logical. Whether to print detailed progress information.}
}
\value{
List containing information about compatible models, including paths and metadata
}
\description{
This function finds compatible GGUF model files from various sources including
Ollama installations, custom directories, or any folder containing GGUF files.
It tests each model for compatibility with edgemodelr and creates organized
copies or links for easy access.
}
\details{
This function performs the following steps:
\enumerate{
\item Searches specified directories (or auto-detects common locations)
\item Identifies GGUF format files above the minimum size threshold
\item Optionally tests each file for compatibility with edgemodelr
\item Creates organized symbolic links or copies in the target directory
\item Returns detailed information about working models
}

The function automatically searches these locations if no source_dirs specified:
\itemize{
\item Ollama models directory (~/.ollama/models or \%USERPROFILE\%/.ollama/models)
\item Current working directory
\item ~/models directory (if exists)
\item Common model storage locations
}
}
\examples{
\dontrun{
# Basic usage - auto-detect and test all GGUF models
models_info <- edge_find_gguf_models()
if (!is.null(models_info) && length(models_info$models) > 0) {
  # Load the first compatible model
  ctx <- edge_load_model(models_info$models[[1]]$path)
  result <- edge_completion(ctx, "Hello", n_predict = 20)
  edge_free_model(ctx)
}

# Search specific directories
models_info <- edge_find_gguf_models(source_dirs = c("~/Downloads", "~/models"))

# Skip compatibility testing (faster but less reliable)
models_info <- edge_find_gguf_models(test_compatibility = FALSE)

# Copy files instead of creating links
models_info <- edge_find_gguf_models(create_links = FALSE)

# Filter for specific models
models_info <- edge_find_gguf_models(model_pattern = "llama")
}
}
