% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{to_percent}
\alias{to_percent}
\title{Format Number as Percentage}
\usage{
to_percent(x, latex = FALSE)
}
\arguments{
\item{x}{Numeric vector to format (as proportions, not percentages)}

\item{latex}{Logical indicating whether to escape percent sign for LaTeX
(default: FALSE)}
}
\value{
Character vector of formatted percentages
}
\description{
Converts numeric values to formatted percentage strings with no decimal
places by default.
}
\examples{
# Format percentages
to_percent(c(0.25, 0.50, 0.123))

# LaTeX-escaped format
to_percent(c(0.25, 0.50), latex = TRUE)
}
