% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leer.inei.web.R
\name{leer.inei.web}
\alias{leer.inei.web}
\title{Leer bases de la ENAHO desde la web}
\usage{
leer.inei.web(
  encuesta = "ENAHO",
  modulo,
  periodos,
  tipo = "anual",
  ensilencio = FALSE,
  combinar = FALSE,
  combinarsolocomunes = FALSE
)
}
\arguments{
\item{encuesta}{el nombre de una encuesta del INEI. Las opciones dispobibles son
\code{"ENAHO"}, \code{"ENAHOpanel"} y \code{"ENDES"}. No importa si está escrito en mayúscula o minúscula.}

\item{modulo}{el código del módulo deseado.}

\item{periodos}{los años deseados.}

\item{tipo}{el tipo de período deseado. Las opciones son \code{"anual"},
  \code{"t1"} (primer trimestre),
  \code{"t2"} (segundo trimestre),
  \code{"t3"} (tercer trimestre),
y \code{"t4"} (cuarto trimestre). Las opciones pueden combinarse.}

\item{ensilencio}{un valor lógico que indica si el progreso de la función debe ser omitido.}

\item{combinar}{un valor lógico que indica si las bases deben ser combinadas en un único data frame.}

\item{combinarsolocomunes}{un valor lógico que indica si sólo deben combinarse las columnas comunes.}
}
\value{
un data frame o una lista.
}
\description{
Lee bases de la ENAHO deste la web del INEI. Aplica las mismas reglas que
\code{\link{leer.inei}}.
}
\examples{
leer.inei.web(modulo = 37, periodos = 2011, tipo = "t1")

}
