% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_void.R
\name{replace_void}
\alias{replace_void}
\title{Replace void values (NA / NULL / "")}
\usage{
replace_void(
  x,
  value = NA,
  include_na = TRUE,
  include_null = TRUE,
  include_empty_str = TRUE
)
}
\arguments{
\item{x}{A vector or list.}

\item{value}{The replacement value to use for voids. Default: \code{NA}.}

\item{include_na}{Logical. Replace \code{NA} if TRUE. Default: TRUE.}

\item{include_null}{Logical. Replace \code{NULL} if TRUE. Default: TRUE.}

\item{include_empty_str}{Logical. Replace empty strings \code{""} if TRUE. Default: TRUE.}
}
\value{
A cleaned vector or list with void values replaced.
}
\description{
Replace elements in a vector or list considered "void" with a specified value.
Void values include \code{NA}, \code{NULL}, and empty strings \code{""} (toggle via flags).
}
\examples{
replace_void(c(NA, "", "a"), value = "N/A")
replace_void(list("A", "", NULL, NA), value = "missing")
replace_void(c("", "b"), value = 0, include_empty_str = TRUE)
}
