% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_poll}
\alias{send_poll}
\title{Send a poll}
\usage{
send_poll(client, number, name, values, selectable_count = 1L, verbose = FALSE)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{number}{Character. Recipient in E.164 format (e.g., \code{"+5581999..."}).}

\item{name}{Question text.}

\item{values}{Character vector of options.}

\item{selectable_count}{Integer (# options a user can select).}

\item{verbose}{Logical. If TRUE, logs request/response details.}
}
\value{
A named list parsed from the JSON response issued by Evolution API,
including fields describing the created poll message (ID, timestamp,
poll options, metadata).
The HTTP status code is stored in \code{attr(result, "http_status")}.
This output represents the API confirmation that the poll was created and dispatched.
}
\description{
Send a poll
}
