% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete.cases.r
\name{complete.cases,GRaster-method}
\alias{complete.cases,GRaster-method}
\alias{complete.cases}
\alias{complete.cases,GVector-method}
\alias{missing.cases,GRaster-method}
\alias{missing.cases}
\alias{missing.cases,GVector-method}
\title{Rows of a GRaster or GVector's table that have no NAs or that have NAs}
\usage{
\S4method{complete.cases}{GRaster}(..., levels = TRUE)

\S4method{complete.cases}{GVector}(...)

\S4method{missing.cases}{GRaster}(..., levels = TRUE)

\S4method{missing.cases}{GVector}(...)
}
\arguments{
\item{...}{A \code{GRaster} or \code{GVector}.}

\item{levels}{Logical (\code{GRaster}s only): If \code{TRUE} (default), then assess only the "value" and \code{\link[=activeCat]{activeCat()}} columns of the levels table (see \code{\link[=levels]{levels()}}). If \code{FALSE}, then assess all columns (see \code{\link[=cats]{cats()}}).}
}
\value{
Both \code{complete.cases()} and \code{missing.cases()} return the same type of object. The output depends on the input:
\itemize{
\item A categorical \code{GRaster} with just one layer: A logical vector.
\item An integer, float, or double \code{GRaster} with just one layer: \code{NA}.
\item A \code{GRaster} with multiple layers: A list with one element per layer with either logical vectors or \code{NA}s, as per above.
\item A \code{GVector} with a data table: A logical vector.
\item A \code{GVector} without a data table: \code{NA}.
}
}
\description{
When applied to a categorical \code{GRaster}, \code{compete.cases()} returns \code{TRUE} for each row of the "levels" table that has no \code{NA}s in it. In contrast, \code{missing.cases()} returns \code{TRUE} for each row that has at least one \code{NA} in it. If the raster is not categorical, then \code{NA} is returned.

When applied to a \code{GVector} with a data table, \code{complete.cases()} returns \code{TRUE} for each row where there are no \code{NA}s. if the \code{GVector} has no data table, then a vector of \code{TRUE} values the same length as the total number of geometries will be returned. In contrast, \code{missing.cases()} returns \code{TRUE} for every row that has at least one \code{NA} in it. If the \code{GVector} has no data table, then a vector of \code{FALSE} values is returned.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Plant specimens (points) and land cover
madDypsis <- fastData("madDypsis")
madCover <- fastData("madCover")

# Convert to GVector and GRaster
dypsis <- fast(madDypsis)
cover <- fast(madCover)

### GVector

# Look at the data table:
as.data.table(dypsis)

# Which rows have no NAs?
complete.cases(dypsis)

# Which rows have at least one NA (opposite of above)?
missing.cases(dypsis)

### GRaster

# Look at the levels table:
levels(cover)

# Which rows of levels table have no NAs?
complete.cases(cover)

# Which rows have at least one NA (opposite of above)?
missing.cases(cover)

}
}
\seealso{
\code{\link[=missingCats]{missingCats()}}
}
