% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastexplain.R
\name{fastexplain}
\alias{fastexplain}
\title{Explain a fastml model using various techniques}
\usage{
fastexplain(
  object,
  method = "dalex",
  features = NULL,
  variables = NULL,
  observation = NULL,
  grid_size = 20,
  shap_sample = 5,
  vi_iterations = 10,
  seed = 123,
  loss_function = NULL,
  protected = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{fastml} object.}

\item{method}{Character string specifying the explanation method.
Supported values are \code{"dalex"}, \code{"lime"}, \code{"ice"},
\code{"ale"}, \code{"surrogate"}, \code{"interaction"}, \code{"studio"},
\code{"fairness"}, \code{"breakdown"}, and \code{"counterfactual"}.
Defaults to \code{"dalex"}.}

\item{features}{Character vector of feature names for partial dependence (model profiles). Default NULL.}

\item{variables}{Character vector. Variable names to compute explanations for (used for counterfactuals).}

\item{observation}{A single observation for methods that need a new data point
(\code{method = "counterfactual"} or \code{method = "breakdown"}). Default NULL.}

\item{grid_size}{Number of grid points for partial dependence. Default 20.}

\item{shap_sample}{Integer number of observations from processed training data to compute SHAP values for. Default 5.}

\item{vi_iterations}{Integer. Number of permutations for variable importance (B). Default 10.}

\item{seed}{Integer. A value specifying the random seed.}

\item{loss_function}{Function. The loss function for \code{model_parts}.
\itemize{
  \item If \code{NULL} and task = 'classification', defaults to \code{DALEX::loss_cross_entropy}.
  \item If \code{NULL} and task = 'regression', defaults to \code{DALEX::loss_root_mean_square}.
}}

\item{protected}{Character or factor vector of protected attribute(s) required for
\code{method = "fairness"}. Default NULL.}

\item{...}{Additional arguments passed to the underlying helper functions
for the chosen \code{method}.}
}
\value{
For DALEX-based methods, prints variable importance, model profiles, and SHAP summaries.
  Other methods return their respective explainer objects (e.g., LIME explanations, ALE plot,
  surrogate tree, interaction strengths, modelStudio dashboard, fairmodels object, breakdown
  object, or counterfactual results), usually invisibly after plotting or printing.
}
\description{
Provides model explainability across several backends. With \code{method = "dalex"} it:
\itemize{
  \item Creates a DALEX explainer from the trained model.
  \item Computes permutation-based variable importance with \code{vi_iterations} permutations and displays the table and plot.
  \item Computes partial dependence-like model profiles when \code{features} are supplied.
  \item Computes Shapley values (SHAP) for \code{shap_sample} training rows, displays the SHAP table,
  and plots a summary bar chart of \eqn{\text{mean}(\vert \text{SHAP value} \vert)} per feature. For classification, separate bars per class are shown.
}
}
\details{
\itemize{
   \item \bold{Method dispatch:} \code{method} can route to LIME, ICE, ALE, surrogate tree, interaction strengths,
   DALEX/modelStudio dashboards, fairness diagnostics, iBreakDown contributions, or counterfactual search.
   \item \bold{Variable importance controls:} Use \code{vi_iterations} to tune permutation stability and \code{loss_function}
   to override the default DALEX loss (cross-entropy for classification, RMSE for regression).
   \item \bold{Fairness and breakdown support:} Provide \code{protected} for \code{method = "fairness"} and an \code{observation}
   for \code{method = "breakdown"} or \code{method = "counterfactual"}. Observations are aligned to the explainer data before scoring.
 }
}
