% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdadist.R
\name{fdadist}
\alias{fdadist}
\title{Computes the distance matrix for functional data with amplitude and phase
separation}
\usage{
fdadist(
  x,
  y = NULL,
  is_domain_interval = FALSE,
  transformation = c("identity", "srvf"),
  warping_class = c("none", "shift", "dilation", "affine", "bpd"),
  metric = c("l2", "normalized_l2", "pearson"),
  cluster_on_phase = FALSE,
  labels = NULL
)
}
\arguments{
\item{x}{A numeric vector of length \eqn{M} or a numeric matrix of shape
\eqn{N \times M} or an object of class \code{\link[funData:funData-class]{funData::funData}}. If a numeric
vector or matrix, it specifies the grid(s) of size \eqn{M} on which each of
the \eqn{N} curves have been observed. If an object of class
\code{\link[funData:funData-class]{funData::funData}}, it contains the whole functional data set and the \code{y}
argument is not used.}

\item{y}{Either a numeric matrix of shape \eqn{N \times M} or a numeric array
of shape \eqn{N \times L \times M} or an object of class \code{\link[fda:fd]{fda::fd}}. If a
numeric matrix or array, it specifies the \eqn{N}-sample of
\eqn{L}-dimensional curves observed on grids of size \eqn{M}. If an object
of class \code{\link[fda:fd]{fda::fd}}, it contains all the necessary information about the
functional data set to be able to evaluate it on user-defined grids.}

\item{is_domain_interval}{A boolean specifying whether the sample of curves
is defined on a fixed interval. Defaults to \code{FALSE}.}

\item{transformation}{A string specifying the transformation to apply to the
original sample of curves. Choices are no transformation (\code{transformation = "identity"}) or square-root velocity function \code{transformation = "srvf"}.
Defaults to \code{"identity"}.}

\item{warping_class}{A string specifying the class of warping functions.
Choices are no warping (\code{warping_class = "none"}), shift \code{y = x + b}
(\code{warping_class = "shift"}), dilation \code{y = ax} (\code{warping_class = "dilation"}), affine \code{y = ax + b} (\code{warping_class = "affine"}) or
boundary-preserving diffeomorphism (\code{warping_class = "bpd"}). Defaults to
\code{"none"}.}

\item{metric}{A string specifying the metric used to compare curves. Choices
are \code{"l2"}, \code{"normalized_l2"} or \code{"pearson"}. If \code{transformation == "srvf"}, the metric \strong{must be} \code{"l2"} because the SRVF transform maps
absolutely continuous functions to square-integrable functions. If
\code{transformation == "identity"} and \code{warping_class} is either \code{dilation} or
\code{affine}, the metric cab be either \code{"normalized_l2"} or \code{"pearson"}. The L2
distance is indeed \strong{not} dilation-invariant or affine-invariant. The
metric can also be \code{"l2"} if \code{warping_class == "shift"}. Defaults to
\code{"l2"}.}

\item{cluster_on_phase}{A boolean specifying whether clustering should be
based on phase variation or amplitude variation. Defaults to \code{FALSE} which
implies amplitude variation.}

\item{labels}{A character vector specifying curve labels. Defaults to \code{NULL}
which uses sequential numbers as labels.}
}
\value{
A \link[stats:dist]{stats::dist} object storing the distance matrix between the input
curves using the metric specified through the argument \code{metric} and the
warping class specified by the argument \code{warping_class}.
}
\description{
This function computes the matrix of pairwise distances between curves a
functional data sample. This can be achieved with or without phase and
amplitude separation, which can be done using a variety of warping classes.
}
\examples{
\dontshow{if (requireNamespace("lpSolve", quietly = TRUE)) withAutoprint(\{ # examplesIf}
idx <- c(1:5, 11:15, 21:25)
D <- fdadist(simulated30_sub$x[idx, ], simulated30_sub$y[idx, , ])
\dontshow{\}) # examplesIf}
}
