% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lindley.R
\name{dlindley}
\alias{dlindley}
\alias{plindley}
\alias{qlindley}
\alias{rlindley}
\title{One-Parameter Lindley Distribution}
\usage{
dlindley(x, theta = 1, log = FALSE)

plindley(q, theta = 1, lower.tail = TRUE, log.p = FALSE)

qlindley(p, theta = 1, lower.tail = TRUE, log.p = FALSE)

rlindley(n, theta = 1)
}
\arguments{
\item{x}{a single value or vector of positive values.}

\item{theta}{distribution parameter value. Default is 1.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p). If
FALSE, probabilities p are given directly. Default is FALSE.}

\item{q}{a single value or vector of quantiles.}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are
returned, otherwise \eqn{P(X > x)} is returned. Default is TRUE.}

\item{p}{a single value or vector of probabilities.}

\item{n}{number of random values to generate.}
}
\value{
dlindley gives the density, plindley gives the distribution 
 function, qlindley gives the quantile function, and rlindley generates
 random  deviates.

 The length of the result is determined by n for rlindley, and is the 
 maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Distribution function for the one-parameter Lindley distribution
  with parameter theta.
}
\details{
Probability density function (PDF)
\deqn{f(x\mid \theta )=\frac{\theta ^{2}}{(1+\theta )}(1+x)e^{-\theta x}}

Cumulative distribution function (CDF)
\deqn{F(x\mid \theta ) =
  1 - \left(1+ \frac{\theta x}{1+\theta }\right)e^{-\theta x}}

Quantile function (Inverse CDF)
\deqn{
Q(p\mid\theta) = -1 - \frac{1}{\theta}
  - \frac{1}{\theta} W_{-1}\!\left((1+\theta)(p-1)e^{-(1+\theta)}\right)
}

where \eqn{W_{-1}()} is the negative branch of the Lambert W function.

The moment generating function (MGF) is:
\deqn{M_X(t)=\frac{\theta^2(\theta-t+1)}{(\theta+1)(\theta-t)^2}}

The distribution mean and variance are:
\deqn{\mu=\frac{\theta+2}{\theta(1+\theta)}}
\deqn{\sigma^2=\frac{\mu}{\theta+2}\left(\frac{6}{\theta}-4\right)-\mu^2}
}
\examples{
x <- seq(0, 5, by = 0.1)
p <- seq(0.1, 0.9, by = 0.1)
q <- c(0.2, 3, 0.2)
dlindley(x, theta = 1.5)
dlindley(x, theta=0.5, log=TRUE)
plindley(q, theta = 1.5)
plindley(q, theta = 0.5, lower.tail = FALSE)
qlindley(p, theta = 1.5)
qlindley(p, theta = 0.5)

set.seed(123154)
rlindley(5, theta = 1.5)
rlindley(5, theta = 0.5)

}
