% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{africa_trade}
\alias{africa_trade}
\title{Intra-African Trade Flows by HS Section}
\format{
A data.table with 27,721 rows and 8 columns:
\describe{
  \item{iso3_o}{Factor. Exporter (origin) country ISO 3166-1 alpha-3 code (47 countries).}
  \item{iso3_d}{Factor. Importer (destination) country ISO 3166-1 alpha-3 code (47 countries).}
  \item{section_code}{Integer. HS section code (1 to 21).}
  \item{section_name}{Factor. HS section description (21 categories, e.g.,
    "Live animals and animal products", "Mineral products", "Machinery and mechanical appliances...").}
  \item{hs2_codes}{Factor. Comma-separated HS 2-digit codes within the section
    (e.g., "84, 85" for machinery).}
  \item{value}{Numeric. Trade value in thousands of USD (current prices).}
  \item{value_kd}{Numeric. Trade value in thousands of constant 2015 USD.}
  \item{quantity}{Numeric. Trade quantity in metric tons.}
}
}
\source{
CEPII BACI Database (HS96 nomenclature), Version 202401b, released 2024-04-09.
Available at \url{https://www.cepii.fr/DATA_DOWNLOAD/baci/doc/baci_webpage.html}.

Reference: Gaulier, G. and Zignago, S. (2010). BACI: International Trade Database
at the Product-Level. The 1994-2007 Version. CEPII Working Paper, N 2010-23.
}
\usage{
data(africa_trade)
}
\description{
A dataset containing bilateral trade flows between 47 African countries, aggregated by
HS (Harmonized System) section. Values represent annual averages over 2012-2022 from
the CEPII BACI database (HS96 nomenclature).
}
\details{
The dataset provides bilateral trade flows aggregated from HS 6-digit product codes
(via HS 2-digit) to 21 HS sections. Trade values and quantities are annual averages
computed over the 2012-2022 period.

HS sections cover broad product categories:
\itemize{
  \item Sections 1-5: Animal and vegetable products
  \item Sections 6-7: Chemical and plastic products
  \item Sections 8-14: Raw materials and manufactured goods
  \item Sections 15-16: Base metals and machinery
  \item Sections 17-21: Transport, instruments, and miscellaneous
}

Note: Some country pairs may have sparse trade relationships. Very small values
indicate limited trade below typical reporting thresholds.
}
\examples{
data(africa_trade)
head(africa_trade)

# Number of trading pairs
length(unique(paste(africa_trade$iso3_o, africa_trade$iso3_d)))

# Total trade by section
aggregate(value ~ section_name, data = africa_trade, FUN = sum)

# Largest bilateral flows
africa_trade[order(-africa_trade$value), ][1:10, ]

# Trade between specific countries
subset(africa_trade, iso3_o == "ZAF" & iso3_d == "NGA")

}
\seealso{
\code{\link{africa_cities_ports}}, \code{\link{africa_network}}, \link{flownet-package}
}
\keyword{datasets}
