% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{linestrings_to_graph}
\alias{linestrings_to_graph}
\title{Convert Linestring to Graph}
\usage{
linestrings_to_graph(
  lines,
  digits = 6,
  keep.cols = is.atomic,
  compute.length = TRUE
)
}
\arguments{
\item{lines}{An sf data frame of LINESTRING geometries.}

\item{digits}{Numeric rounding applied to coordinates (to ensure that matching points across different linestrings is not impaired by numeric precision issues). Set to \code{NA/Inf/FALSE} to disable.}

\item{keep.cols}{Character vector of column names to keep from the input data frame.}

\item{compute.length}{Applies \code{st_length()} to and saves it as an additional column named \code{".length"}.}
}
\value{
A data.frame representing the graph with columns:
\itemize{
 \item \code{edge} - Edge identifier
 \item \code{from} - Starting node ID
 \item \code{FX} - Starting node X-coordinate (longitude)
 \item \code{FY} - Starting node Y-coordinate (latitude)
 \item \code{to} - Ending node ID
 \item \code{TX} - Ending node X-coordinate (longitude)
 \item \code{TY} - Ending node Y-coordinate (latitude)
}
}
\description{
Convert Linestring to Graph
}
\examples{
library(flownet)
library(sf)

# Load existing network edges (exclude proposed new links)
africa_net <- africa_network[!africa_network$add, ]

# Convert network LINESTRING geometries to graph
graph <- linestrings_to_graph(africa_net)
head(graph)

# Graph contains edge, from/to nodes, and coordinates
names(graph)

}
\seealso{
\link{simplify_network} \link{flownet-package}
}
