% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{nodes_from_graph}
\alias{nodes_from_graph}
\title{Extract Nodes from Graph}
\usage{
nodes_from_graph(graph_df, sf = FALSE, crs = 4326)
}
\arguments{
\item{graph_df}{A data frame representing a graph with columns:
\code{from}, \code{to}, \code{FX}, \code{FY}, \code{TX}, \code{TY}.}

\item{sf}{Logical. If TRUE, returns result as an \code{sf} POINT object. Default: FALSE.}

\item{crs}{Coordinate reference system for sf output; default is 4326.}
}
\value{
A data frame (or sf object if \code{sf = TRUE}) with unique nodes and coordinates:
  \itemize{
    \item \code{node} - Node ID
    \item \code{X} - Node X-coordinate (typically longitude)
    \item \code{Y} - Node Y-coordinate (typically latitude)
  }
  Result is sorted by node ID.
}
\description{
Extract unique nodes with their coordinates from a graph data frame.
}
\details{
This function extracts all unique nodes from both the \code{from} and \code{to}
columns of the graph, along with their corresponding coordinates. Duplicate nodes
are removed, keeping only unique node IDs with their coordinates.
}
\examples{
library(flownet)
library(sf)

# Load existing network edges and convert to graph
africa_net <- africa_network[!africa_network$add, ]
graph <- linestrings_to_graph(africa_net)

# Extract nodes from graph
nodes <- nodes_from_graph(graph)
head(nodes)

# Get nodes as sf POINT object for spatial operations
nodes_sf <- nodes_from_graph(graph, sf = TRUE)
class(nodes_sf)

# Find nearest network nodes to cities/ports
nearest_nodes <- nodes_sf$node[st_nearest_feature(africa_cities_ports, nodes_sf)]
head(nearest_nodes)

}
