% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmi_functions.R
\name{test_scalar}
\alias{test_scalar}
\title{Test for Scalar Invariance}
\usage{
test_scalar(Y_mat, group_vec, argvals, pooled_fpca, n_perms, alpha, progress)
}
\arguments{
\item{Y_mat}{Numeric matrix (N x M).}

\item{group_vec}{A vector of length N specifying group membership.}

\item{argvals}{Numeric vector of length M.}

\item{pooled_fpca}{The \code{fpca.sc} object from the \code{determine_npc} function.}

\item{n_perms}{Integer, number of permutations.}

\item{alpha}{Significance level (default: 0.05).}

\item{progress}{Boolean, show progress bar? (default: interactive()).}
}
\value{
A list with \code{passed} (boolean), \code{p_value}, and \code{statistic}.
}
\description{
Permutation test to check if the mean functions (intercepts)
are equivalent across groups, after accounting for latent factors.
}
\examples{
\donttest{
  sim <- simulate_fmi_data(N_A = 20, N_B = 20, T_points = 30)
  npc_info <- determine_npc(sim$Y_mat, sim$argvals, max_npc = 3)
  res <- test_scalar(sim$Y_mat, sim$group_vec, sim$argvals,
                     pooled_fpca = npc_info$pooled_fpca,
                     n_perms = 9, alpha = 0.05, progress = FALSE)
  print(res$p_value)
}
}
