% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real_time_04_phaseII.R
\name{control_charts_sof_pc_real_time}
\alias{control_charts_sof_pc_real_time}
\title{Real-time scalar-on-function regression control charts}
\usage{
control_charts_sof_pc_real_time(
  mod_list,
  y_test,
  mfdobj_x_test,
  mfdobj_x_tuning = NULL,
  alpha = list(T2 = 0.0125, spe = 0.0125, y = 0.025),
  limits = "standard",
  seed,
  nfold = NULL,
  ncores = 1
)
}
\arguments{
\item{mod_list}{A list of lists produced by \code{\link{sof_pc_real_time}},
containing a list of scalar-on-function linear regression models estimated
on functional data each evolving up to an intermediate domain point.}

\item{y_test}{A numeric vector containing the observations of
the scalar response variable in the phase II monitoring data set.}

\item{mfdobj_x_test}{A list created using
\code{\link{get_mfd_df_real_time}} or
\code{get_mfd_list_real_time}, denoting a list of functional data objects
in the phase II monitoring data set,
each evolving up to an intermediate domain point,
with observations of the multivariate functional covariates.
The length of this list and \code{mod_list} must be equal,
and their elements in the same position in the list
must correspond to the same intermediate domain point.}

\item{mfdobj_x_tuning}{A list created using
\code{\link{get_mfd_df_real_time}} or
\code{get_mfd_list_real_time}, denoting a list of functional data objects
in the tuning data set (used to estimate control chart limits),
each evolving up to an intermediate domain point,
with observations of the multivariate functional covariates.
The length of this list and \code{mod_list} must be equal,
and their elements in the same position in the list
must correspond to the same intermediate domain point.
If NULL, the training data, i.e. the functional covariates
in \code{mod_list},
are also used as the tuning data set.
Default is NULL.}

\item{alpha}{See \code{\link{control_charts_sof_pc}}.}

\item{limits}{See \code{\link{control_charts_sof_pc}}.}

\item{seed}{Deprecated: see \code{\link{control_charts_sof_pc}}.}

\item{nfold}{See \code{\link{control_charts_sof_pc}}.}

\item{ncores}{If you want parallelization, give the number of cores/threads
to be used when creating objects separately for different instants.}
}
\value{
A list of \code{data.frame}s each
produced by \code{\link{control_charts_sof_pc}},
corresponding to a given instant.
}
\description{
This function is deprecated. Use \code{\link{regr_cc_sof_real_time}}.
This function produces a list of data frames,
each of them is produced by \code{\link{control_charts_sof_pc}}
and is needed to plot control charts for monitoring in real time
a scalar quality characteristic adjusted for
by the effect of multivariate functional covariates.
}
\examples{
\donttest{
library(funcharts)
data("air")
air1 <- lapply(air, function(x) x[1:8, , drop = FALSE])
air2 <- lapply(air, function(x) x[9:10, , drop = FALSE])
mfdobj_x1_list <- get_mfd_list_real_time(air1[c("CO", "temperature")],
                                         n_basis = 15,
                                         lambda = 1e-2,
                                         k_seq = c(0.5, 1))
mfdobj_x2_list <- get_mfd_list_real_time(air2[c("CO", "temperature")],
                                         n_basis = 15,
                                         lambda = 1e-2,
                                         k_seq = c(0.5, 1))
y1 <- rowMeans(air1$NO2)
y2 <- rowMeans(air2$NO2)
mod_list <- sof_pc_real_time(y1, mfdobj_x1_list)
cclist <- control_charts_sof_pc_real_time(
  mod_list = mod_list,
  y_test = y2,
  mfdobj_x_test = mfdobj_x2_list)
plot_control_charts_real_time(cclist, 1)
}

}
\seealso{
\code{\link{sof_pc_real_time}}, \code{\link{control_charts_sof_pc}}
}
