% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.cobra.R
\name{predict.cobra}
\alias{predict.cobra}
\title{Predict Using COBRA object}
\usage{
\method{predict}{cobra}(object, data, ...)
}
\arguments{
\item{object}{An object of class "cobra" created by the \code{cobra} function.}

\item{data}{A \code{data.frame} of new data, where rows are observations and
columns are predictions from individual learners. Use \code{NA} for missing predictions.}

\item{...}{Additional arguments (currently not used).}
}
\value{
A vector of predictions for the new data.
}
\description{
#' The \code{predict.cobra} function makes predictions on new data using a trained COBRA object.
}
\examples{
# Example usage
set.seed(123)
x_train <- data.frame(a = rnorm(10L), b = rnorm(10L))
y_train <- sample(0L:1L, size = 10L, replace = TRUE)

# Train the model with epsilon optimization
cobra_model <- cobra(x = x_train, y = y_train, tune = "epsilon")

# Make predictions on new data
set.seed(156)
x_new <- data.frame(a = rnorm(5L), b = rnorm(5L))
prediction <- predict(object = cobra_model, data = x_new)
}
