% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_db.R
\name{aggr_by_freq}
\alias{aggr_by_freq}
\title{Aggregate Data by Frequency}
\usage{
aggr_by_freq(
  table,
  freq,
  prep_fun,
  aggr_funs,
  postp_funs,
  variable_name,
  preprocess_body
)
}
\arguments{
\item{table}{[mandatory] (data.frame) A wide-format data frame.}

\item{freq}{[mandatory] (character) Specifies the frequency to aggregate the
data.}

\item{prep_fun}{[mandatory] (function) Pre-processing function used during
daily expansion prior to aggregation. This is guaranteed to be a function
because \code{read_db()} replaces \code{NULL} with \code{linear_interp()}.}

\item{aggr_funs}{[optional] (function or list) Aggregation function(s) used
when aggregating to \code{freq}.
\itemize{
  \item If a single function is provided, it is used for all variables.
  \item If an unnamed list of functions is provided, all functions are
    applied to all variables (treated as \code{default}).
  \item If a named list is provided, names must be variable names (as
    returned by \code{fetch_vars}) and/or \code{"default"}; named entries
    override the default for those variables.
}}

\item{postp_funs}{[optional] (function or list or \code{"external"}) Post-
processing function(s) applied after aggregation.
\itemize{
  \item If a single function or \code{NULL} is provided, it is used for
    all variables as \code{default}.
  \item If an unnamed list of functions is provided, all are applied to
    all variables (treated as \code{default}).
  \item If a named list is provided, names must be variable names (as
    returned by \code{fetch_vars}) and/or \code{"default"}; named entries
    override the default for those variables.
  \item If \code{"external"}, functions are loaded from \code{postp/}.
}
Default is \code{NULL}.}

\item{variable_name}{[mandatory] (character) Name of the current variable.}

\item{preprocess_body}{[mandatory] (character) Body of the \code{prep_fun}
function.}
}
\value{
A data frame in wide format with aggregated values.
}
\description{
Aggregates data from a wide-format data frame according to a specified
frequency and applies aggregation and post-processing functions.
}
\keyword{internal}
