% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_db.R
\name{read_db}
\alias{read_db}
\title{Reading, Aggregating, and Processing the SQLite Database}
\usage{
read_db(
  path,
  variables = "all",
  freq = c("month", "day", "week", "bimonth", "quarter", "season", "halfyear", "year"),
  prep_fun = NULL,
  aggr_funs = function(x) mean(x, na.rm = TRUE),
  postp_funs = NULL
)
}
\arguments{
\item{path}{[mandatory] (character) Path to the root directory of the
generated database.}

\item{variables}{[optional] (character or integer) Names or IDs of the
variables to be read. Use the \code{fetch_vars} function to identify
available variables and IDs (default: \code{"all"}).}

\item{freq}{[optional] (character or \code{NULL}) The frequency for data
aggregation. Options include \code{"day"}, \code{"week"}, \code{"month"},
\code{"bimonth"}, \code{"quarter"}, \code{"season"}, \code{"halfyear"},
\code{"year"} (default: \code{"month"}). If \code{NULL}, no aggregation is
performed and native dates are returned.}

\item{prep_fun}{[optional] (function or \code{NULL}) A function for
pre-processing time series data after expanding to daily frequency and
before aggregation. This daily expansion is performed whenever
\code{freq} is not \code{NULL}. If \code{prep_fun = NULL} (default),
linear interpolation (via \code{\link{linear_interp}}) is applied on the
daily series. If \code{freq = NULL}, no preprocessing is performed and
native dates are returned.}

\item{aggr_funs}{[optional] (function or list) Aggregation function(s) used
when aggregating to \code{freq}.
\itemize{
  \item If a single function is provided, it is used for all variables.
  \item If an unnamed list of functions is provided, all functions are
    applied to all variables (treated as \code{default}).
  \item If a named list is provided, names must be variable names (as
    returned by \code{fetch_vars}) and/or \code{"default"}; named entries
    override the default for those variables.
}}

\item{postp_funs}{[optional] (function or list or \code{"external"}) Post-
processing function(s) applied after aggregation.
\itemize{
  \item If a single function or \code{NULL} is provided, it is used for
    all variables as \code{default}.
  \item If an unnamed list of functions is provided, all are applied to
    all variables (treated as \code{default}).
  \item If a named list is provided, names must be variable names (as
    returned by \code{fetch_vars}) and/or \code{"default"}; named entries
    override the default for those variables.
  \item If \code{"external"}, functions are loaded from \code{postp/}.
}
Default is \code{NULL}.}
}
\description{
Reads, aggregates, and processes the SQLite database
  (\code{data/geelite.db}).
}
\examples{
# Example: Reading variables by IDs
\dontrun{
  db_list <- read_db(path = "path/to/db",
    variables = c(1, 3))
}

}
