% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subfeats.R
\name{as_subfeats}
\alias{as_subfeats}
\alias{as_subfeats.tbl_df}
\title{Compute a layout for subfeat data}
\usage{
as_subfeats(x, seqs, feats, ..., everything = TRUE)

\method{as_subfeats}{tbl_df}(
  x,
  seqs,
  feats,
  ...,
  everything = TRUE,
  transform = c("none", "aa2nuc", "nuc2aa")
)
}
\arguments{
\item{x}{subfeat data convertible to a feat layout}

\item{seqs}{the sequence layout the parent feats map onto.}

\item{feats}{the parent feats the subfeats map onto.}

\item{...}{passed on to \code{layout_seqs()}
spaces, i.e. if matching nucleotide-level annotations to protein level
annotations, e.g. genes and protein blast results.}

\item{everything}{set to FALSE to drop optional columns}

\item{transform}{use if feats and subfeats are in different coordinate}
}
\value{
a tbl_df with plot coordinates
}
\description{
Read subfeat data such as domains or blast hits on genes into a tidy
dataframe. Subfeats need to be associated with an already added feat
track. The subfeat track itself is internally converted into a new,
regular feat track by mapping the \code{start} and \code{end} coordinates provided
relative to their parent feat into coordinates relative to the sequences
underlying the parent feats.
}
\details{
Obligatory columns are \code{feat_id}, \code{start} and \code{end}. Also recognized are
\code{strand} and \code{bin_id}.

Note \code{start} and \code{end} for every record will be coerced so that \code{start < end}. If no \code{strand} was provided, \code{strand} will be added and set to "+" for
records that initially had \code{start < end} and "-" for \code{end < start} inputs. If
\code{strand} was provided, \code{start} and \code{end} will be reorganized to conform with
\code{start < end} without any additional effect.
}
\section{Methods (by class)}{
\itemize{
\item \code{as_subfeats(tbl_df)}: Convert a list of tibbles into a feat layout

}}
\keyword{internal}
