% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_geodata.R
\name{check_geodata}
\alias{check_geodata}
\title{Check and Download Geospatial Data}
\usage{
check_geodata(
  files = NULL,
  overwrite = FALSE,
  quiet = FALSE,
  max_retries = 3,
  mirrors = NULL,
  use_checksum = TRUE,
  checksums = NULL,
  resume = TRUE,
  local_dirs = NULL
)
}
\arguments{
\item{files}{Character vector of file names. If `NULL`, all known files are used.}

\item{overwrite}{Logical. Force re-download even if a non-empty file exists.
Default `FALSE`.}

\item{quiet}{Logical. Suppress progress and messages. Default `FALSE`.}

\item{max_retries}{Integer. Max retry attempts per (mirror, file). Default `3`.}

\item{mirrors}{Character vector of base URLs (end with `/`). Tried in order.
Default: jsDelivr first, then GitHub raw.}

\item{use_checksum}{Logical. Verify SHA-256 when available. Default `TRUE`.}

\item{checksums}{Named character vector of SHA-256 digests (names = file names).
If `NULL`, built-in defaults are used for known files; unknown files skip verification.}

\item{resume}{Logical. Try HTTP range resume if a `.part` exists (only for
writable dirs). Default `TRUE`.}

\item{local_dirs}{Character vector of directories to search \emph{before}
any download. If a matching non-empty file is found and \code{overwrite = FALSE},
it is returned immediately.}
}
\value{
Character vector of absolute file paths (NA for failures).
}
\description{
Ensure required geodata files exist locally. The function searches and reuses
existing files (when \code{overwrite = FALSE}) \emph{before} attempting any
network download, in the following order:
\enumerate{
  \item user-provided \strong{local_dirs}
  \item installed package \strong{extdata} (even if not writable)
  \item per-user cache \strong{tools::R_user_dir("ggmapcn","data")}
}
If no valid local file is found (or \code{overwrite = TRUE}), the function
downloads from mirrors \emph{in order}. By default, a China-friendly CDN
(jsDelivr) is tried first, then GitHub raw.

Robust features: multiple mirrors, atomic writes, resume, timeouts, retries,
safe checksum checks, and correct \code{curl} progress callback.
}
\examples{
\donttest{
# Basic: ensure default files exist
check_geodata()

# Single file: reuse existing file if present (default overwrite = FALSE)
check_geodata(files = "boundary.rda")

# Force re-download a file (e.g., suspected corruption)
check_geodata(files = "boundary.rda", overwrite = TRUE)

# Search local folders first; skip download if a valid file is found there
check_geodata(
  files = c("boundary.rda", "world.rda"),
  local_dirs = c(getwd())  # add more directories if needed
)

# Provide your own mirror order (first tried wins)
check_geodata(
  files = "boundary.rda",
  mirrors = c(
    "https://cdn.jsdelivr.net/gh/Rimagination/ggmapcn-data@main/data/",
    "https://raw.githubusercontent.com/Rimagination/ggmapcn-data/main/data/"
  )
)
}

}
