% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_world.R
\name{geom_world}
\alias{geom_world}
\title{Plot World Map with Customizable Options}
\usage{
geom_world(
  data = NULL,
  crs = "+proj=longlat +datum=WGS84",
  color = "black",
  fill = "white",
  linewidth = 0.5,
  filter_attribute = "SOC",
  filter = NULL,
  ...
)
}
\arguments{
\item{data}{An `sf` object containing world map data. If `NULL`, the default world map data
from the package will be loaded from a `.rda` file.}

\item{crs}{A character string specifying the target coordinate reference system (CRS) for the map projection.
Defaults to `"+proj=longlat +datum=WGS84"`.}

\item{color}{A character string specifying the border color for administrative boundaries. Default is `"black"`.}

\item{fill}{A character string specifying the fill color for administrative areas. Default is `"white"`.}

\item{linewidth}{A numeric value specifying the line width for administrative boundaries. Default is `0.5`.}

\item{filter_attribute}{A character string specifying the column name used for filtering countries or regions.
Default is `"SOC"`, which refers to the ISO 3166-1 alpha-3 country code in the default dataset.}

\item{filter}{A character vector specifying the values to filter specific countries or regions. Default is `NULL`.}

\item{...}{Additional parameters passed to [ggplot2::geom_sf()], such as `size`, `alpha`, or `lty`.}
}
\value{
A `ggplot2` layer for world map visualization.
}
\description{
A wrapper around [ggplot2::geom_sf()] for visualizing world maps with customizable options.
This function allows for custom projections, filtering specific countries or regions, and detailed
aesthetic customizations for borders and fills.
}
\details{
This function simplifies the process of creating world maps by combining the functionality of `geom_sf`
with user-friendly options for projections, filtering, and custom styling.
Key features include:
- **Custom projections**: Easily apply any CRS to the map.
- **Filtering by attributes**: Quickly focus on specific countries or regions.
- **Flexible aesthetics**: Customize fill, borders, transparency, and other visual properties.
}
\examples{
\donttest{
  # Plot the default world map
  ggplot() +
    geom_world() +
    theme_minimal()

  # Using Robinson projection with central meridian at 0°
  ggplot() +
    geom_world(crs = "+proj=robin +lon_0=0 +x_0=0 +y_0=0 +datum=WGS84 +units=m") +
    theme_minimal()

  # Filter specific countries (e.g., China and its neighbors)
  china_neighbors <- c("CHN", "AFG", "BTN", "MMR", "LAO", "NPL", "PRK", "KOR",
                       "KAZ", "KGZ", "MNG", "IND", "BGD", "TJK", "PAK", "LKA", "VNM")
  ggplot() +
    geom_world(filter = china_neighbors) +
    theme_minimal()

  # Background map + Highlight specific region
  ggplot() +
    geom_world(fill = "gray80", color = "gray50", alpha = 0.5) +
    geom_world(filter = c("CHN"), fill = "red", color = "black", linewidth = 1.5) +
    theme_minimal()

  # Customize styles with transparency and bold borders
  ggplot() +
    geom_world(fill = "lightblue", color = "darkblue", linewidth = 1, alpha = 0.8) +
    theme_void()
}
}
\seealso{
[ggplot2::geom_sf()], [sf::st_transform()],
[sf::st_read()]
}
