% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{ggml_with_temp_ctx}
\alias{ggml_with_temp_ctx}
\title{Execute with Temporary Context}
\usage{
ggml_with_temp_ctx(mem_size, expr)
}
\arguments{
\item{mem_size}{Context memory size in bytes}

\item{expr}{Expression to evaluate with the temporary context}
}
\value{
Result of the expression
}
\description{
Creates a temporary context, executes code, and frees it automatically.
Useful when you need to create large temporary tensors.
}
\examples{
\donttest{
# Create tensors in temporary context
result <- ggml_with_temp_ctx(1024 * 1024, {
  a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
  ggml_set_f32(a, 1:10)
  ggml_get_f32(a)
})
}
}
