% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MullerPlot.R
\name{path_vector_new}
\alias{path_vector_new}
\title{Faster way to record a path through all nodes of an adjacency matrix}
\usage{
path_vector_new(
  tree,
  i = NULL,
  Adj = NULL,
  Col = NULL,
  is_leaf = NULL,
  path = NULL
)
}
\arguments{
\item{tree}{Dataframe comprising an adjacency matrix, with column names "Parent" and "Identity"}

\item{i}{Current node}

\item{Adj}{Adjacency matrix}

\item{Col}{Node label}

\item{is_leaf}{Label whether node is a leaf}

\item{path}{The path vector so far}
}
\value{
A list, including a vector specifying the path.
}
\description{
Nodes are traversed in the order that they should be stacked in a Muller plot. 
Each node appears exactly twice.
}
\examples{
edges1 <- data.frame(Parent = c(1,1,1,3,3), Identity = 2:6)
path_vector_new(edges1)$path

}
\author{
Rob Noble, \email{robjohnnoble@gmail.com}
}
