% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmFEL-helpers.R
\name{glmmfe_trAB}
\alias{glmmfe_trAB}
\title{Fast trace of a matrix product}
\usage{
glmmfe_trAB(A, B)
}
\arguments{
\item{A, B}{Numeric matrices with identical dimensions.}
}
\value{
A single numeric scalar equal to \code{tr(A \%*\% B)}.
}
\description{
Internal helper to compute \eqn{\mathrm{tr}(A B)} without forming \code{A \%*\% B}:
\deqn{\mathrm{tr}(A B) = \sum (A \circ B^\top).}

This identity is used repeatedly in the fully exponential (FE) trace
corrections (Karl, Yang, and Lohr, 2014, Appendix B), where a naive
\code{diag(A \%*\% B)} would allocate the full product.
}
\keyword{internal}
