% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmodelPlot.R
\name{ggmodelPlot}
\alias{ggmodelPlot}
\title{Mixed model effects plot using ggplot2}
\usage{
ggmodelPlot(
  object,
  geneName = NULL,
  x1var = NULL,
  x2var = NULL,
  x2shift = NULL,
  xlab = NULL,
  ylab = geneName,
  plab = NULL,
  title = geneName,
  logTransform = is(object, "GlmmSeq"),
  shapes = 19,
  colours = "grey60",
  lineColours = "grey60",
  markerSize = 1,
  fontSize = 12,
  alpha = 0.7,
  x2Offset = 5,
  addPoints = TRUE,
  addModel = TRUE,
  modelSize = 4,
  modelColours = "blue",
  modelLineSize = 1,
  modelLineColours = modelColours,
  addBox = FALSE,
  ...
)
}
\arguments{
\item{object}{A glmmSeq/lmmSeq object created by
\code{\link[glmmSeq:glmmSeq]{glmmSeq::glmmSeq()}} or
\code{\link[glmmSeq:lmmSeq]{glmmSeq::lmmSeq()}}}

\item{geneName}{The gene/row name to be plotted}

\item{x1var}{The name of the first (inner) x parameter, typically 'time'.
This is anticipated to have different values when matched by ID.}

\item{x2var}{The name of an optional second (outer) x parameter, which should be a
factor.}

\item{x2shift}{Amount to shift along x axis for each level of \code{x2var}. By
default the function will arrange each level of \code{x2var} side by side.}

\item{xlab}{Title for the x axis}

\item{ylab}{Title for the y axis}

\item{plab}{Optional character vector of labels for p-values. These must
align with column names in \code{object@stats$pvals}.}

\item{title}{Plot title. If NULL gene name is used}

\item{logTransform}{Whether to perform a log10 transform on the y axis}

\item{shapes}{The marker shapes (default=19)}

\item{colours}{The marker colours as vector}

\item{lineColours}{The line colours (default='grey60') as vector}

\item{markerSize}{Size of markers (default=1)}

\item{fontSize}{Plot font size}

\item{alpha}{Line and marker opacity (default=0.7)}

\item{x2Offset}{Vertical adjustment to secondary x-axis labels (default=5)}

\item{addPoints}{Whether to add underlying data points (default=TRUE)}

\item{addModel}{Whether to add the fit model with markers (default=TRUE)}

\item{modelSize}{Size of model points (default=4)}

\item{modelColours}{Colour of model fit markers (default="blue") as vector}

\item{modelLineSize}{Size of model points (default=1) as vector}

\item{modelLineColours}{Colour of model fit lines}

\item{addBox}{Logical whether to add boxplots for mean and IQR}

\item{...}{Other parameters to pass to
\code{\link[ggplot2:theme]{ggplot2::theme()}}.}
}
\value{
Returns a paired plot for matched samples.
}
\description{
Plot to show differences between groups and over time using ggplot2.
}
\examples{
data(PEAC_minimal_load)

disp <- apply(tpm, 1, function(x){
  (var(x, na.rm=TRUE)-mean(x, na.rm=TRUE))/(mean(x, na.rm=TRUE)**2)
})

MS4A1glmm <- glmmSeq(~ Timepoint * EULAR_6m + (1 | PATID),
                     countdata = tpm['MS4A1', , drop = FALSE],
                     metadata = metadata,
                     dispersion = disp,
                     verbose = FALSE)

ggmodelPlot(object = MS4A1glmm,
           geneName = 'MS4A1',
           x1var = 'Timepoint',
           x2var = 'EULAR_6m',
           colours = c('skyblue', 'goldenrod1', 'mediumvioletred'))
}
