% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mono-type.R
\name{convert_to_generic}
\alias{convert_to_generic}
\alias{convert_to_generic.character}
\alias{convert_to_generic.glyrepr_structure}
\alias{convert_to_generic.glyrepr_composition}
\title{Convert Monosaccharides to Generic Type}
\usage{
convert_to_generic(x)

\method{convert_to_generic}{character}(x)

\method{convert_to_generic}{glyrepr_structure}(x)

\method{convert_to_generic}{glyrepr_composition}(x)
}
\arguments{
\item{x}{Either of these objects:
\itemize{
\item A character of monosaccharide;
\item A glycan composition vector ("glyrepr_composition" object);
\item A glycan structure vector ("glyrepr_structure" object).
}}
}
\value{
A new object of the same class as \code{x}
with monosaccharides converted to generic type.
}
\description{
This function converts monosaccharide types of monosaccharide characters,
glycan compositions, or glycan structures from concrete to generic type.
This is a simplified version that only supports conversion from "concrete"
to "generic" monosaccharides.
}
\section{Two types of monosaccharides}{
There are two types of monosaccharides:
\itemize{
\item concrete: e.g. "Gal", "GlcNAc", "Glc", "Fuc", etc.
\item generic: e.g. "Hex", "HexNAc", "HexA", "HexN", etc.
}

For the full list of monosaccharides, use \code{\link[=available_monosaccharides]{available_monosaccharides()}}.
}

\examples{
# Convert character vectors
convert_to_generic(c("Gal", "GlcNAc"))

# Convert glycan compositions
comps <- glycan_composition(
  c(Gal = 5, GlcNAc = 2),
  c(Glc = 5, GalNAc = 4, Fuc = 1)
)
convert_to_generic(comps)

# Convert glycan structures
strucs <- c(n_glycan_core(), o_glycan_core_1())
convert_to_generic(strucs)

}
